/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.boot.PluginVersions;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class Upgrader {
    private ApplicationContext context;
    private JcrTemplate jcrTemplate;
    private ListMultimap<String, Upgrade> upgradeBeans;
    private boolean questionAsked = false;
    private static final Logger logger = LoggerFactory.getLogger(Upgrader.class);

    @Autowired
    public Upgrader(ApplicationContext applicationContext, JcrTemplate jcrTemplate) {
        this.context = applicationContext;
        this.jcrTemplate = jcrTemplate;
    }

    @PostConstruct
    public void doUpgrade() {
        this.upgradeBeans = this.getUpgrades();
        Set set = PluginVersions.getRegisteredPlugins();
        for (String string : Iterables.concat((Iterable)Lists.newArrayList((Object[])new String[]{"deployit"}), (Iterable)set)) {
            logger.debug("Checking component [{}] for upgrades", (Object)string);
            this.upgradeComponent(string);
        }
    }

    void upgradeComponent(String string) {
        Version version = this.readVersionOfComponent(string);
        List<Upgrade> list = this.filterUpgrades(Upgrader.ensureNotNull(this.upgradeBeans.get((Object)string)), version);
        if (!list.isEmpty()) {
            Collections.sort(list);
            logger.info("Checked component [{}] which is at version [{}] -> Found upgrades to run: {}", new Object[]{string, version, list});
            if (!this.questionAsked) {
                System.out.println("*** WARNING ***");
                System.out.println("We detected that we need to upgrade your Deployit repository");
                System.out.println("Before continuing we suggest you backup your Deployit repository in case the upgrade fails.");
                System.out.println("Please ensure you have 'INFO' level logging configured.");
                System.out.print("Please enter 'yes' if you want to continue [no]: ");
                String string2 = this.read();
                if (!string2.equalsIgnoreCase("yes")) {
                    EventBus.publish(new ShutdownEvent());
                    return;
                }
                this.questionAsked = true;
            }
            this.applyUpgrades(list);
        } else if (version.equals((Object)Version.valueOf((String)string, (String)"0.0.0"))) {
            Version version2 = Version.valueOf((String)string, (String)PluginVersions.getVersionFor((String)string));
            logger.info("Registering previous unregistered version: [{}]", (Object)version2);
            this.storeVersionOfComponent(version2);
        }
    }

    void storeVersionOfComponent(final Version version) {
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                Node node = Upgrader.this.getVersionsNode(session);
                node.setProperty(version.getComponent(), version.getVersion());
                session.save();
                return null;
            }
        });
    }

    Version readVersionOfComponent(final String string) {
        return this.jcrTemplate.execute(new JcrCallback<Version>(){

            @Override
            public Version doInJcr(Session session) throws IOException, RepositoryException {
                Node node = Upgrader.this.getVersionsNode(session);
                if (node.hasProperty(string)) {
                    Property property = node.getProperty(string);
                    return Version.valueOf((String)string, (String)property.getString());
                }
                return Version.valueOf((String)string, (String)"0.0.0");
            }
        });
    }

    private Node getVersionsNode(Session session) throws RepositoryException {
        try {
            return session.getNode("/$configuration/versions");
        }
        catch (PathNotFoundException pathNotFoundException) {
            return session.getRootNode().addNode("$configuration/versions");
        }
    }

    private void applyUpgrades(List<Upgrade> list) {
        final ImmutableListMultimap immutableListMultimap = Multimaps.index(list, (Function)new Function<Upgrade, Version>(){

            public Version apply(Upgrade upgrade) {
                return upgrade.upgradeVersion();
            }
        });
        ArrayList arrayList = Lists.newArrayList((Iterable)Lists.transform(list, (Function)new Function<Upgrade, Version>(){

            public Version apply(Upgrade upgrade) {
                return upgrade.upgradeVersion();
            }
        }));
        Collections.sort(arrayList);
        for (final Version version : arrayList) {
            logger.info("Upgrading to version [{}]", (Object)version);
            this.jcrTemplate.execute(new JcrCallback<Object>(){

                @Override
                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    for (Upgrade upgrade : immutableListMultimap.get((Object)version)) {
                        if (upgrade.doUpgrade((RawRepository)new RawRepositoryImpl(session))) continue;
                        throw new UpgradeException("Could not perform upgrade %s to upgrade to %s", new Object[]{upgrade.getClass(), upgrade.upgradeVersion()});
                    }
                    session.save();
                    return null;
                }
            });
            this.storeVersionOfComponent(version);
        }
    }

    private List<Upgrade> filterUpgrades(Collection<Upgrade> collection, final Version version) {
        ArrayList arrayList = Lists.newArrayList((Iterable)Collections2.filter(collection, (Predicate)new Predicate<Upgrade>(){

            public boolean apply(Upgrade upgrade) {
                return upgrade.shouldBeApplied(version);
            }
        }));
        Collections.sort(arrayList);
        return arrayList;
    }

    protected ListMultimap<String, Upgrade> getUpgrades() {
        Set set = ReflectionsHolder.getSubTypesOf(Upgrade.class);
        return Multimaps.index((Iterable)Collections2.transform((Collection)set, (Function)new Function<Class<? extends Upgrade>, Upgrade>(){

            public Upgrade apply(Class<? extends Upgrade> clazz) {
                return (Upgrade)Upgrader.this.context.getAutowireCapableBeanFactory().createBean(clazz);
            }
        }), (Function)new Function<Upgrade, String>(){

            public String apply(Upgrade upgrade) {
                return upgrade.upgradeVersion().getComponent();
            }
        });
    }

    protected String read() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string = bufferedReader.readLine();
            if (string != null) {
                return string.trim();
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static <T> List<T> ensureNotNull(List<T> list) {
        return list == null ? Lists.newArrayList() : list;
    }
}

