/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.ssh.SshInteractiveSudoConnection;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.ssh.SshSftpCygwinConnection;
import com.xebialabs.overthere.ssh.SshSftpUnixConnection;
import com.xebialabs.overthere.ssh.SshSftpWinSshdConnection;
import com.xebialabs.overthere.ssh.SshSudoConnection;
import com.xebialabs.overthere.ssh.SshTunnelConnection;

@Protocol(name="ssh")
public class SshConnectionBuilder
implements OverthereConnectionBuilder {
    public static final String SSH_PROTOCOL = "ssh";
    public static final String CONNECTION_TYPE = "connectionType";
    public static final int SSH_PORT_DEFAULT = 22;
    public static final String INTERACTIVE_KEYBOARD_AUTH_PROMPT_REGEX = "interactiveKeyboardAuthRegex";
    public static final String INTERACTIVE_KEYBOARD_AUTH_PROMPT_REGEX_DEFAULT = ".*Password:[ ]?";
    public static final String PRIVATE_KEY_FILE = "privateKeyFile";
    public static final String PASSPHRASE = "passphrase";
    public static final String ALLOCATE_DEFAULT_PTY = "allocateDefaultPty";
    public static final boolean ALLOCATE_DEFAULT_PTY_DEFAULT = false;
    public static final String ALLOCATE_PTY = "allocatePty";
    public static final String ALLOCATE_PTY_DEFAULT = null;
    public static final String SUDO_USERNAME = "sudoUsername";
    public static final String SUDO_COMMAND_PREFIX = "sudoCommandPrefix";
    public static final String SUDO_COMMAND_PREFIX_DEFAULT = "sudo -u {0}";
    public static final String SUDO_QUOTE_COMMAND = "sudoQuoteCommand";
    public static final boolean SUDO_QUOTE_COMMAND_DEFAULT = false;
    public static final String SUDO_OVERRIDE_UMASK = "sudoOverrideUmask";
    public static final boolean SUDO_OVERRIDE_UMASK_DEFAULT = false;
    public static final String SUDO_PASSWORD_PROMPT_REGEX = "sudoPasswordPromptRegex";
    public static final String SUDO_PASSWORD_PROMPT_REGEX_DEFAULT = ".*[Pp]assword.*:";
    public static final String PORT_ALLOCATION_RANGE_START = "portAllocationRangeStart";
    public static final int PORT_ALLOCATION_RANGE_START_DEFAULT = 1025;
    protected SshConnection connection;

    public SshConnectionBuilder(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        SshConnectionType sshConnectionType = (SshConnectionType)((Object)connectionOptions.get(CONNECTION_TYPE));
        switch (sshConnectionType) {
            case TUNNEL: {
                this.connection = new SshTunnelConnection(string, connectionOptions, addressPortMapper);
                break;
            }
            case SFTP: {
                this.connection = new SshSftpUnixConnection(string, connectionOptions, addressPortMapper);
                break;
            }
            case SFTP_CYGWIN: {
                this.connection = new SshSftpCygwinConnection(string, connectionOptions, addressPortMapper);
                break;
            }
            case SFTP_WINSSHD: {
                this.connection = new SshSftpWinSshdConnection(string, connectionOptions, addressPortMapper);
                break;
            }
            case SCP: {
                this.connection = new SshScpConnection(string, connectionOptions, addressPortMapper);
                break;
            }
            case SUDO: {
                this.connection = new SshSudoConnection(string, connectionOptions, addressPortMapper);
                break;
            }
            case INTERACTIVE_SUDO: {
                this.connection = new SshInteractiveSudoConnection(string, connectionOptions, addressPortMapper);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SSH connection type " + (Object)((Object)sshConnectionType));
            }
        }
    }

    @Override
    public OverthereConnection connect() {
        this.connection.connect();
        return this.connection;
    }

    public String toString() {
        return this.connection.toString();
    }
}

