/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DeploymentTrendsPercentileWidget
extends DashboardWidgetBase {
    private static final int EIGHTIETH_PERCENTILE = 80;

    private DeploymentTrendsPercentileWidget(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public static final Widget getInstance(TaskArchive taskArchive) {
        return new DeploymentTrendsPercentileWidget(taskArchive);
    }

    @Override
    public Report getReport(Date date, Date date2) {
        Map<String, List<DeploymentTaskInfo>> map = this.groupSuccesfulTasksByMonth(date, date2);
        Map<String, Long> map2 = this.calculatePercentiles(map);
        return this.generateReportData(map2);
    }

    private Map<String, List<DeploymentTaskInfo>> groupSuccesfulTasksByMonth(Date date, Date date2) {
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters().createdBetween(date.getCalendar(), date2.getCalendar()).thatCompleted();
        final Map<String, List<DeploymentTaskInfo>> map = this.initializeMap(date, date2, new Function<String, List<DeploymentTaskInfo>>(){

            public List<DeploymentTaskInfo> apply(String string) {
                return Lists.newArrayList();
            }
        });
        this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new JcrTaskArchive.TaskCallback(){

            public void doWithTask(DeploymentTaskInfo deploymentTaskInfo) {
                String string = DeploymentTrendsPercentileWidget.this.monthFormat.format(deploymentTaskInfo.getCompletionDate().getTime());
                List list = (List)map.get(string);
                if (list != null) {
                    list.add(deploymentTaskInfo);
                }
            }
        });
        return map;
    }

    private Map<String, Long> calculatePercentiles(Map<String, List<DeploymentTaskInfo>> map) {
        return Maps.transformValues(map, (Function)new Function<List<DeploymentTaskInfo>, Long>(){

            public Long apply(List<DeploymentTaskInfo> list) {
                return DeploymentTrendsPercentileWidget.this.getPercentile(list, 80);
            }
        });
    }

    private long getPercentile(List<DeploymentTaskInfo> list, int n) {
        if (list.size() == 0) {
            return 0L;
        }
        Collections.sort(list, new Comparator<DeploymentTaskInfo>(){

            @Override
            public int compare(DeploymentTaskInfo deploymentTaskInfo, DeploymentTaskInfo deploymentTaskInfo2) {
                return (int)(deploymentTaskInfo.getDurationInMillis() - deploymentTaskInfo2.getDurationInMillis());
            }
        });
        int n2 = Long.valueOf(Math.round((double)n * (double)list.size() / 100.0 + 0.5)).intValue();
        if (n2 > 0) {
            --n2;
        }
        DeploymentTaskInfo deploymentTaskInfo = list.get(n2);
        return deploymentTaskInfo.getDurationInMillis();
    }

    private Report generateReportData(Map<String, Long> map) {
        Report report = new Report();
        ReportTimeScale reportTimeScale = this.findTimeScale(map);
        block4: for (String string : map.keySet()) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("month", (Object)string);
            reportLine.addValue("timeScale", (Object)reportTimeScale.toString());
            switch (reportTimeScale) {
                case SECS: {
                    reportLine.addValue("deploymentTime", (Object)this.formatToSecs(map.get(string)));
                    continue block4;
                }
                case MINS: {
                    reportLine.addValue("deploymentTime", (Object)this.formatToMins(map.get(string)));
                    continue block4;
                }
            }
            reportLine.addValue("deploymentTime", (Object)this.formatToHours(map.get(string)));
        }
        return report;
    }

    private ReportTimeScale findTimeScale(Map<String, Long> map) {
        Long l = Collections.max(map.values());
        if (TimeUnit.MILLISECONDS.toSeconds(l) < 600L) {
            return ReportTimeScale.SECS;
        }
        if (TimeUnit.MILLISECONDS.toMinutes(l) < 600L) {
            return ReportTimeScale.MINS;
        }
        return ReportTimeScale.HRS;
    }

    private static enum ReportTimeScale {
        SECS,
        MINS,
        HRS;

    }
}

