/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.scanner;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javassist.bytecode.ClassFile;
import nl.javadude.scannit.registry.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScanner {
    private static final Predicate<String> INCLUDE_ALL = Predicates.alwaysTrue();
    private Predicate<String> filter = INCLUDE_ALL;

    public void addFilter(Predicate<CharSequence> filter) {
        this.filter = Predicates.and(filter, this.filter);
    }

    public void clearFilter() {
        this.filter = INCLUDE_ALL;
    }

    public boolean accepts(String name) {
        return this.filter.apply((Object)name);
    }

    public void scan(ClassFile file, Registry registry) {
        if (this.accepts(file.getName())) {
            this.doScan(file, registry);
        }
    }

    protected abstract void doScan(ClassFile var1, Registry var2);
}

