/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.CRC32Exception;
import de.schlichtherle.truezip.zip.ZipEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

final class Crc32CheckingInputStream
extends CheckedInputStream {
    private final ZipEntry entry;
    private final int size;

    Crc32CheckingInputStream(InputStream in, ZipEntry entry, int size) {
        super(in, new CRC32());
        this.entry = entry;
        this.size = size;
    }

    @Override
    public long skip(long toSkip) throws IOException {
        long len;
        long total = 0L;
        byte[] buf = new byte[this.size];
        while ((len = toSkip - total) > 0L && (len = (long)this.read(buf, 0, len < (long)buf.length ? (int)len : buf.length)) >= 0L) {
            total += len;
        }
        return total;
    }

    @Override
    public void close() throws IOException {
        while (this.skip(Long.MAX_VALUE) > 0L) {
        }
        super.close();
        long expected = this.entry.getCrc();
        long computed = this.getChecksum().getValue();
        if (expected != computed) {
            throw new CRC32Exception(this.entry.getName(), expected, computed);
        }
    }
}

