/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm.connector;

import com.google.common.io.Closeables;
import com.xebialabs.overthere.cifs.winrm.HttpConnector;
import com.xebialabs.overthere.cifs.winrm.SoapAction;
import com.xebialabs.overthere.cifs.winrm.TokenGenerator;
import com.xebialabs.overthere.cifs.winrm.exception.BlankValueRuntimeException;
import com.xebialabs.overthere.cifs.winrm.exception.InvalidFilePathRuntimeException;
import com.xebialabs.overthere.cifs.winrm.exception.WinRMRuntimeIOException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkHttpConnector
implements HttpConnector {
    private final URL targetURL;
    private final TokenGenerator tokenGenerator;
    private static Logger logger = LoggerFactory.getLogger(JdkHttpConnector.class);

    public JdkHttpConnector(URL uRL, TokenGenerator tokenGenerator) {
        this.targetURL = uRL;
        this.tokenGenerator = tokenGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document sendMessage(Document document, SoapAction soapAction) {
        try {
            int n;
            URLConnection uRLConnection = this.targetURL.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/soap+xml; charset=UTF-8");
            String string = this.tokenGenerator.generateToken();
            if (string != null) {
                httpURLConnection.addRequestProperty("Authorization", string);
            }
            if (soapAction != null) {
                httpURLConnection.setRequestProperty("SOAPAction", soapAction.getValue());
            }
            String string2 = this.toString(document);
            logger.trace("Sending request to {}", (Object)this.targetURL);
            logger.trace("Request body: {}", (Object)this.targetURL, (Object)string2);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(httpURLConnection.getOutputStream()));
            try {
                bufferedWriter.write(string2, 0, string2.length());
            }
            finally {
                Closeables.closeQuietly((Closeable)bufferedWriter);
            }
            InputStream inputStream = null;
            if (httpURLConnection.getResponseCode() >= 400) {
                inputStream = httpURLConnection.getErrorStream();
            }
            if (inputStream == null) {
                inputStream = httpURLConnection.getInputStream();
            }
            StringWriter stringWriter = new StringWriter();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            try {
                char[] cArray = new char[1024];
                while ((n = bufferedReader.read(cArray)) != -1) {
                    ((Writer)stringWriter).write(cArray, 0, n);
                }
            }
            finally {
                Closeables.closeQuietly((Closeable)bufferedReader);
                Closeables.closeQuietly((Closeable)inputStream);
            }
            if (logger.isDebugEnabled()) {
                for (n = 0; n < httpURLConnection.getHeaderFields().size(); ++n) {
                    logger.trace("Header {}: {}", (Object)httpURLConnection.getHeaderFieldKey(n), (Object)httpURLConnection.getHeaderField(n));
                }
            }
            String string3 = ((Object)stringWriter).toString();
            logger.trace("Response body: {}", (Object)string3);
            return DocumentHelper.parseText((String)string3);
        }
        catch (BlankValueRuntimeException blankValueRuntimeException) {
            throw blankValueRuntimeException;
        }
        catch (InvalidFilePathRuntimeException invalidFilePathRuntimeException) {
            throw invalidFilePathRuntimeException;
        }
        catch (Exception exception) {
            throw new WinRMRuntimeIOException("Send message on " + this.targetURL + " error ", document, null, exception);
        }
    }

    private String toString(Document document) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
        try {
            xMLWriter.write(document);
            xMLWriter.close();
        }
        catch (IOException iOException) {
            throw new WinRMRuntimeIOException("Cannnot convert XML to String ", iOException);
        }
        return stringWriter.toString();
    }
}

