/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.ssh.SshScpFile;
import com.xebialabs.overthere.ssh.SshSudoConnection;
import com.xebialabs.overthere.ssh.SshSudoOutputStream;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.LoggingOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereProcessOutputHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSudoFile
extends SshScpFile {
    private boolean isTempFile;
    private Logger logger = LoggerFactory.getLogger(SshSudoFile.class);

    public SshSudoFile(SshSudoConnection sshSudoConnection, String string, boolean bl) {
        super(sshSudoConnection, string);
        this.isTempFile = bl;
    }

    @Override
    protected int executeCommand(OverthereProcessOutputHandler overthereProcessOutputHandler, CmdLine cmdLine) {
        if (this.isTempFile) {
            cmdLine = SshConnection.prefixWithPseudoCommand(cmdLine, "nosudo");
        }
        return super.executeCommand(overthereProcessOutputHandler, cmdLine);
    }

    @Override
    public OverthereFile getFile(String string) {
        SshSudoFile sshSudoFile = (SshSudoFile)super.getFile(string);
        sshSudoFile.isTempFile = this.isTempFile;
        return sshSudoFile;
    }

    @Override
    public OverthereFile getParentFile() {
        SshSudoFile sshSudoFile = (SshSudoFile)super.getParentFile();
        sshSudoFile.isTempFile = this.isTempFile;
        return sshSudoFile;
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.getInputStream();
        }
        OverthereFile overthereFile = ((SshScpConnection)this.connection).getTempFile(this.getName());
        this.copyToTempFile(overthereFile);
        return overthereFile.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.getOutputStream();
        }
        this.logger.debug("Opening ssh:sudo: output stream to write to file {}", (Object)this);
        return new SshSudoOutputStream(this, ((SshScpConnection)this.connection).getTempFile(this.getName()));
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        if (this.isTempFile) {
            this.logger.debug("Creating world-writable directory, with sticky bit (mode 01777)");
            this.mkdir("-m", "1777");
        } else {
            super.mkdir();
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        if (this.isTempFile) {
            this.logger.debug("Creating world-writable directories, with sticky bit (mode 01777)");
            this.mkdir("-p", "-m", "1777");
        } else {
            super.mkdirs();
        }
    }

    @Override
    protected void copyFrom(OverthereFile overthereFile) {
        if (this.isTempFile) {
            super.copyFrom(overthereFile);
            this.overrideUmask(this);
        } else {
            this.logger.debug("Copying file or directory {} to {}", (Object)overthereFile, (Object)this);
            OverthereFile overthereFile2 = ((SshScpConnection)this.getConnection()).getTempFile(this.getName());
            try {
                ((SshScpConnection)this.connection).getSshClient().newSCPFileTransfer().newSCPUploadClient().copy((LocalSourceFile)new SshScpFile.OverthereFileLocalSourceFile(overthereFile), overthereFile2.getPath());
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Cannot copy " + overthereFile + " to " + this, iOException);
            }
            this.overrideUmask(overthereFile2);
            this.copyfromTempFile(overthereFile2);
        }
    }

    private void overrideUmask(OverthereFile overthereFile) {
        if (((SshSudoConnection)this.connection).sudoOverrideUmask) {
            this.logger.debug("Overriding umask by recursively setting permissions on files and/or directories copied with scp to be readable and executable (if needed) by group and other");
            CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
            int n = ((SshScpConnection)this.connection).execute(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler), CmdLine.build("nosudo", "nocd", "chmod", "-R", "go+rX", overthereFile.getPath()));
            if (n != 0) {
                throw new RuntimeIOException("Cannot set permissions on file " + this + " to go+rX: " + capturingOverthereProcessOutputHandler.getError() + " (errno=" + n + ")");
            }
        }
    }

    void copyToTempFile(OverthereFile overthereFile) {
        this.logger.debug("Copying actual file {} to temporary file {} before download", (Object)this, (Object)overthereFile);
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
        int n = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler), CmdLine.build("nocd", "cp", "-pr", this.getPath(), overthereFile.getPath()));
        if (n != 0) {
            String string = capturingOverthereProcessOutputHandler.getAll();
            throw new RuntimeIOException("Cannot copy actual file " + this + " to temporary file " + overthereFile + " before download: " + string);
        }
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler2 = CapturingOverthereProcessOutputHandler.capturingHandler();
        int n2 = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler2), CmdLine.build("nocd", "chmod", "-R", "go+rX", overthereFile.getPath()));
        if (n2 != 0) {
            String string = capturingOverthereProcessOutputHandler2.getAll();
            throw new RuntimeIOException("Cannot grant group and other read and execute permissions (chmod -R go+rX) to file " + overthereFile + " before download: " + string);
        }
    }

    void copyfromTempFile(OverthereFile overthereFile) {
        this.logger.debug("Copying temporary file {} to actual file {} after upload", (Object)overthereFile, (Object)this);
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
        CmdLine cmdLine = CmdLine.build("nocd", "cp", "-pr");
        String string = overthereFile.getPath();
        if (this.exists() && overthereFile.isDirectory()) {
            string = string + "/*";
        }
        cmdLine.addRaw(string);
        cmdLine.addArgument(this.getPath());
        int n = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler), cmdLine);
        if (n != 0) {
            String string2 = capturingOverthereProcessOutputHandler.getAll();
            throw new RuntimeIOException("Cannot copy temporary file " + overthereFile + " to actual file " + this + " after upload: " + string2);
        }
    }
}

