/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.event.Event;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.task.ExecutionContextAttributes;
import com.xebialabs.deployit.task.StepList;
import com.xebialabs.deployit.task.TaskStep;
import com.xebialabs.deployit.task.TaskStepInfo;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;

public abstract class Task
implements Serializable,
Runnable {
    private static final String MDC_KEY_TASK_ID = "taskId";
    private String id;
    private String label = "Task #" + this.getClass();
    private String owner;
    private transient Authentication ownerCredentials;
    private Calendar startDate;
    private Calendar completionDate;
    private final StepList steps;
    private volatile boolean stopRequested;
    private volatile transient FutureTask<Object> wrappingTask;
    private volatile State state = State.PENDING;
    private static final Logger logger = LoggerFactory.getLogger(Task.class);

    public Task(List<? extends Step<?>> steps) {
        this(new StepList(steps), State.PENDING);
    }

    Task(StepList stepList, State state) {
        this.steps = stepList;
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeSteps() {
        ExecutionContextAttributes context = new ExecutionContextAttributes();
        try {
            while (this.steps.hasMoreSteps()) {
                TaskStep currentStep = this.steps.getNextStep();
                currentStep.execute(context);
                if (currentStep.isFailed()) {
                    this.steps.rollback();
                    boolean bl = false;
                    return bl;
                }
                if (!this.isAborted() && !this.isStopped()) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            context.destroy();
        }
        return true;
    }

    public void moveStep(int stepNr, int newPosition) {
        Preconditions.checkState((this.state == State.PENDING ? 1 : 0) != 0, (Object)"Cannot move steps when task is not pending anymore.");
        this.steps.move(stepNr, newPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MDC.put((String)MDC_KEY_TASK_ID, (String)this.getId());
        try {
            this.stopRequested = false;
            Preconditions.checkState((!this.isExecuting() ? 1 : 0) != 0, (Object)"task is already executing");
            Preconditions.checkState((this.wrappingTask != null ? 1 : 0) != 0, (Object)"task should have a wrapper set!");
            if (!this.isReadyForExecution()) {
                return;
            }
            if (this.state == State.QUEUED) {
                this.startDate = Calendar.getInstance();
            }
            try {
                this.setState(State.EXECUTING);
                boolean result = this.executeSteps();
                logger.debug("Executed all steps of {}", (Object)this);
                if (!result && this.isAborted()) {
                    this.setState(State.STOPPED);
                } else if (!result && this.steps.hasMoreSteps()) {
                    this.setState(State.STOPPED);
                } else {
                    this.setState(State.DONE);
                }
            }
            finally {
                this.wrappingTask = null;
                Thread.interrupted();
            }
        }
        finally {
            MDC.remove((String)MDC_KEY_TASK_ID);
        }
    }

    public int getFailureCount() {
        int failureCount = 0;
        for (TaskStep step : this.steps) {
            failureCount += step.getFailureCount();
        }
        return failureCount;
    }

    public void doAfterTaskStateChangedToDone() {
    }

    public void doAfterTaskStateChangedToAborted() {
    }

    public void performPreFlightChecks() {
    }

    public void stop() {
        logger.info("Stop requested for {}", (Object)this);
        this.stopRequested = true;
    }

    public void abort() {
        if (this.isExecuting()) {
            this.wrappingTask.cancel(true);
        } else {
            logger.info("Cannot abort task [{}] which is not currently executing.", (Object)this.id);
        }
    }

    public void cancel() {
        Checks.checkArgument(this.isReadyForExecution() || this.state == State.PENDING, "Can only cancel a task that is PENDING or STOPPED", new Object[0]);
        this.setState(State.CANCELLED);
    }

    public void destroy() {
    }

    public boolean isReadyForExecution() {
        return this.state == State.QUEUED || this.state == State.STOPPED;
    }

    public boolean isExecuting() {
        return this.state == State.EXECUTING;
    }

    private boolean isStopped() {
        return this.stopRequested;
    }

    private boolean isAborted() {
        return this.wrappingTask.isCancelled() || Thread.currentThread().isInterrupted();
    }

    public List<TaskStep> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public void setWrappingTask(FutureTask<Object> wrappingTask) {
        this.wrappingTask = wrappingTask;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Authentication getOwnerCredentials() {
        return this.ownerCredentials;
    }

    public void setOwnerCredentials(Authentication ownerCredentials) {
        this.ownerCredentials = ownerCredentials;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public Calendar getCompletionDate() {
        return this.completionDate;
    }

    void setCompletionDate(Calendar completionDate) {
        this.completionDate = completionDate;
    }

    public int getCurrentStepNr() {
        return this.steps.getCurrentStepNr();
    }

    public int getNrOfSteps() {
        return this.steps.getNrOfSteps();
    }

    public TaskStep getStep(int stepNr) {
        return this.steps.getStep(stepNr);
    }

    public FutureTask<Object> getWrappingTask() {
        return this.wrappingTask;
    }

    public State getState() {
        return this.state;
    }

    public void processAfterRecovery() {
        for (TaskStep eachStep : this.getSteps()) {
            if (eachStep.getState() != TaskStepInfo.StepState.EXECUTING) continue;
            eachStep.setLog(eachStep.getLog() + "Step was executing when the server crashed. Try executing it again.\n");
            eachStep.transitionExecutingStateToFailedState();
            this.steps.rollback();
            break;
        }
        this.setState(State.STOPPED);
    }

    void setState(State state) {
        if (state == this.state) {
            return;
        }
        boolean shouldDestroy = false;
        this.state = state;
        switch (state) {
            case QUEUED: {
                logger.info("{} is now queued.", (Object)this);
                break;
            }
            case EXECUTING: {
                logger.info("Execution of {} has started", (Object)this);
                break;
            }
            case STOPPED: {
                logger.error("Execution of {} was stopped", (Object)this);
                this.completionDate = Calendar.getInstance();
                try {
                    this.doAfterTaskStateChangedToAborted();
                    break;
                }
                catch (RuntimeException e) {
                    logger.error("Execution of {} has stopped because of an internal error", (Object)this, (Object)e);
                    this.state = State.STOPPED;
                    throw e;
                }
            }
            case CANCELLED: {
                logger.info("Execution of {} has been cancelled", (Object)this);
                this.completionDate = Calendar.getInstance();
                shouldDestroy = true;
                break;
            }
            case DONE: {
                logger.info("Execution of {} has completed successfully", (Object)this);
                this.completionDate = Calendar.getInstance();
                shouldDestroy = true;
                try {
                    this.doAfterTaskStateChangedToDone();
                    break;
                }
                catch (RuntimeException e) {
                    logger.error("Execution of {} has stopped because of an internal error", (Object)this, (Object)e);
                    this.state = State.STOPPED;
                    throw e;
                }
            }
        }
        try {
            EventBus.publish(new TaskStateChangeEvent(this, this.state));
        }
        catch (RuntimeException e) {
            logger.error("Exception while publishing TaskStateChangeEvent: ", (Throwable)e);
            throw e;
        }
        if (shouldDestroy) {
            this.destroy();
        }
    }

    public String toString() {
        return "task [" + this.id + "]";
    }

    public class TaskStateChangeEvent
    implements Event {
        private final Task task;
        private final State oldState;

        public TaskStateChangeEvent(Task task2, State oldState) {
            this.task = task2;
            this.oldState = oldState;
        }

        public Task getTask() {
            return this.task;
        }

        public State getOldState() {
            return this.oldState;
        }
    }

    public static enum State {
        PENDING,
        QUEUED,
        EXECUTING,
        DONE,
        STOPPED,
        CANCELLED;

    }
}

