/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.dto;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.AbstractDTO;
import com.xebialabs.deployit.core.api.dto.Role;
import com.xebialabs.deployit.core.api.dto.RoleAssignment;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RoleAssignments
extends AbstractDTO {
    private List<RoleAssignment> assignments = Lists.newArrayList();

    public RoleAssignments() {
    }

    public RoleAssignments(List<RoleAssignment> assignments) {
        this.assignments = assignments;
    }

    @XmlElement
    public List<RoleAssignment> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<RoleAssignment> assignments) {
        this.assignments = assignments;
    }

    public void assignRole(final String role, List<String> principals) {
        Collection filter = Collections2.filter(this.assignments, (Predicate)new Predicate<RoleAssignment>(){

            public boolean apply(RoleAssignment input) {
                return input.getRole().getName().equals(role);
            }
        });
        if (!filter.isEmpty()) {
            ((RoleAssignment)filter.iterator().next()).setPrincipals(principals);
        } else {
            this.assignments.add(new RoleAssignment(new Role(role), principals));
        }
    }

    public void removeRole(String role) {
        Iterator<RoleAssignment> it = this.assignments.iterator();
        while (it.hasNext()) {
            RoleAssignment ra = it.next();
            if (!ra.getRole().getName().equals(role)) continue;
            it.remove();
            break;
        }
    }
}

