/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.resteasy.http.tunnel;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.TunneledResponse;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunneledResponseBuilder
extends Response.ResponseBuilder {
    private TunneledResponse tunneledResponse = new TunneledResponse();
    private Headers<Object> metadata = new Headers();
    private static final Map<Class<?>, JAXBContext> CONTEXT_MAP = new MapMaker().makeComputingMap(new Function<Class<?>, JAXBContext>(){

        public JAXBContext apply(Class<?> input) {
            try {
                return JAXBContext.newInstance((Class[])new Class[]{input});
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
    });
    private static final Logger logger = LoggerFactory.getLogger(TunneledResponseBuilder.class);

    public Response build() {
        return new ServerResponse((Object)this.tunneledResponse, 200, this.metadata);
    }

    public Response.ResponseBuilder clone() {
        TunneledResponseBuilder trb = new TunneledResponseBuilder();
        trb.tunneledResponse = this.tunneledResponse;
        trb.metadata.putAll(this.metadata);
        return trb;
    }

    public Response.ResponseBuilder status(int status) {
        logger.debug("Setting status: {}", (Object)status);
        this.tunneledResponse.setStatus(status);
        return this;
    }

    public Response.ResponseBuilder entity(Object entity) {
        logger.trace("Setting entity: {}", entity);
        if (entity == null) {
            return this;
        }
        if (entity.getClass().getAnnotation(XmlRootElement.class) != null) {
            StringWriter writer = new StringWriter();
            try {
                JAXBContext jaxbContext = CONTEXT_MAP.get(entity.getClass());
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.fragment", (Object)true);
                marshaller.marshal(entity, (Writer)writer);
            }
            catch (JAXBException e) {
                throw new IllegalArgumentException("Could not marshal: " + entity, e);
            }
            this.tunneledResponse.setEntity(writer.toString());
        } else {
            this.tunneledResponse.setEntity(entity.toString());
        }
        return this;
    }

    public Response.ResponseBuilder type(MediaType type) {
        return this.addSingleHeader("Content-Type", type);
    }

    public Response.ResponseBuilder type(String type) {
        return this.addSingleHeader("Content-Type", type);
    }

    public Response.ResponseBuilder variant(Variant variant) {
        if (variant.getMediaType() != null) {
            this.type(variant.getMediaType());
        }
        if (variant.getLanguage() != null) {
            this.language(variant.getLanguage());
        }
        if (variant.getEncoding() != null) {
            this.metadata.putSingle("Content-Encoding", (Object)variant.getEncoding());
        }
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        throw new UnsupportedOperationException("Ask Jeroen");
    }

    public Response.ResponseBuilder language(String language) {
        return this.addSingleHeader("Content-Language", language);
    }

    public Response.ResponseBuilder language(Locale language) {
        return this.addSingleHeader("Content-Language", language);
    }

    public Response.ResponseBuilder location(URI location) {
        return this.addSingleHeader("Location", this.absolutize(location));
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        return this.addSingleHeader("Content-Location", this.absolutize(location));
    }

    private URI absolutize(URI location) {
        if (!location.isAbsolute() && ResteasyProviderFactory.getContextData(HttpRequest.class) != null) {
            String path = location.toString();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            URI baseUri = ((HttpRequest)ResteasyProviderFactory.getContextData(HttpRequest.class)).getUri().getBaseUri();
            location = baseUri.resolve(path);
        }
        return location;
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        return this.addSingleHeader("ETag", tag);
    }

    public Response.ResponseBuilder tag(String tag) {
        return this.addSingleHeader("ETag", tag);
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        return this.addSingleHeader("Last-Modified", DateUtil.formatDate((Date)lastModified));
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        return this.addSingleHeader("Cache-Control", cacheControl);
    }

    public Response.ResponseBuilder expires(Date expires) {
        return this.addSingleHeader("Expires", new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").format(expires));
    }

    public Response.ResponseBuilder header(String name, Object value) {
        return this.addHeader(name, value);
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        logger.debug("Setting cookies: {}", (Object[])cookies);
        if (cookies == null) {
            this.metadata.remove((Object)"Set-Cookie");
            return this;
        }
        for (NewCookie cookie : cookies) {
            this.metadata.add("Set-Cookie", (Object)cookie);
        }
        return this;
    }

    private Response.ResponseBuilder addSingleHeader(String headerName, Object headerValue) {
        logger.debug("Adding header: {}: {}", (Object)headerName, headerValue);
        this.metadata.putSingle(headerName, headerValue);
        this.tunneledResponse.addSingleHeader(headerName, headerValue);
        return this;
    }

    private Response.ResponseBuilder addHeader(String headerName, Object headerValue) {
        logger.debug("Adding header: {}: {}", (Object)headerName, headerValue);
        this.metadata.add(headerName, headerValue);
        this.tunneledResponse.addHeader(headerName, headerValue);
        return this;
    }
}

