/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.telnet;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CifsTelnetConnection
extends CifsConnection {
    private static final String DETECTABLE_WINDOWS_PROMPT = "TELNET4OVERTHERE ";
    private static final String ERRORLEVEL_PREAMBLE = "ERRORLEVEL-PREAMBLE";
    private static final String ERRORLEVEL_POSTAMBLE = "ERRORLEVEL-POSTAMBLE";
    public static final int EXITCODE_CANNOT_DETERMINE_ERRORLEVEL = -999999;
    private static Logger logger = LoggerFactory.getLogger(CifsTelnetConnection.class);

    public CifsTelnetConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper, true);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection to a non-Windows operating system", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase()});
    }

    @Override
    public OverthereProcess startProcess(final CmdLine commandLine) {
        final String commandLineForExecution = commandLine.toCommandLine(this.getHostOperatingSystem(), false);
        try {
            final TelnetClient tc = new TelnetClient();
            tc.setConnectTimeout(this.connectionTimeoutMillis);
            tc.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(299, 25, true, false, true, false));
            logger.info("Connecting to telnet://{}@{}", (Object)this.username, (Object)this.address);
            tc.connect(this.address, this.port);
            final InputStream stdout = tc.getInputStream();
            final OutputStream stdin = tc.getOutputStream();
            final PipedInputStream callersStdout = new PipedInputStream();
            final PipedOutputStream toCallersStdout = new PipedOutputStream(callersStdout);
            final ByteArrayOutputStream outputBuf = new ByteArrayOutputStream();
            final int[] result = new int[]{-999999};
            final Thread processOutputReaderThread = new Thread("Process handler reader for command " + commandLine){

                @Override
                public void run() {
                    try {
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, "ogin:");
                        CifsTelnetConnection.send(stdin, CifsTelnetConnection.this.username);
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, "assword:");
                        CifsTelnetConnection.send(stdin, CifsTelnetConnection.this.password);
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, ">", "ogon failure");
                        CifsTelnetConnection.send(stdin, "PROMPT TELNET4OVERTHERE ");
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        if (CifsTelnetConnection.this.workingDirectory != null) {
                            CifsTelnetConnection.send(stdin, "CD " + CifsTelnetConnection.this.workingDirectory.getPath());
                            CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        }
                        CifsTelnetConnection.send(stdin, commandLineForExecution);
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        CifsTelnetConnection.send(stdin, "ECHO \"ERRORLEVEL-PREAMBLE%errorlevel%ERRORLEVEL-POSTAMBLE");
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.ERRORLEVEL_POSTAMBLE);
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.ERRORLEVEL_POSTAMBLE);
                        String outputBufStr = outputBuf.toString();
                        int preamblePos = outputBufStr.indexOf(CifsTelnetConnection.ERRORLEVEL_PREAMBLE);
                        int postamblePos = outputBufStr.indexOf(CifsTelnetConnection.ERRORLEVEL_POSTAMBLE);
                        if (preamblePos >= 0 && postamblePos >= 0) {
                            String errorlevelString = outputBufStr.substring(preamblePos + CifsTelnetConnection.ERRORLEVEL_PREAMBLE.length(), postamblePos);
                            logger.debug("Errorlevel string found: {}", (Object)errorlevelString);
                            try {
                                result[0] = Integer.parseInt(errorlevelString);
                            }
                            catch (NumberFormatException exc) {
                                logger.error("Cannot parse errorlevel in Windows output: " + outputBuf);
                            }
                        } else {
                            logger.error("Cannot find errorlevel in Windows output: " + outputBuf);
                        }
                    }
                    catch (IOException exc) {
                        throw new RuntimeIOException("Cannot start process " + commandLine, exc);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)toCallersStdout);
                    }
                }
            };
            processOutputReaderThread.start();
            return new OverthereProcess(){

                @Override
                public OutputStream getStdin() {
                    return stdin;
                }

                @Override
                public InputStream getStdout() {
                    return callersStdout;
                }

                @Override
                public InputStream getStderr() {
                    return new ByteArrayInputStream(new byte[0]);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int waitFor() {
                    try {
                        try {
                            processOutputReaderThread.join();
                        }
                        finally {
                            this.destroy();
                        }
                        return result[0];
                    }
                    catch (InterruptedException exc) {
                        throw new RuntimeIOException("Cannot execute command " + commandLine + " on " + CifsTelnetConnection.this.address, exc);
                    }
                }

                @Override
                public void destroy() {
                    if (tc.isConnected()) {
                        try {
                            tc.disconnect();
                            logger.info("Disconnected from telnet://{}@{}", (Object)CifsTelnetConnection.this.username, (Object)CifsTelnetConnection.this.address);
                            Closeables.closeQuietly((Closeable)toCallersStdout);
                        }
                        catch (IOException exc) {
                            throw new RuntimeIOException("Cannot disconnect from telnet://" + CifsTelnetConnection.this.username + "@" + CifsTelnetConnection.this.address, exc);
                        }
                    }
                }
            };
        }
        catch (InvalidTelnetOptionException exc) {
            throw new RuntimeIOException("Cannot execute command " + commandLine + " at telnet://" + this.username + "@" + this.address, exc);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute command " + commandLine + " at telnet://" + this.username + "@" + this.address, exc);
        }
    }

    private static void receive(InputStream stdout, ByteArrayOutputStream outputBuf, PipedOutputStream toCallersStdout, String expectedString) throws IOException {
        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, expectedString, null);
    }

    private static void receive(InputStream stdout, ByteArrayOutputStream outputBuf, PipedOutputStream toCallersStdout, String expectedString, String unexpectedString) throws IOException {
        String s;
        String outputBufStr;
        boolean lastCharWasCr = false;
        boolean lastCharWasEsc = false;
        do {
            int cInt;
            if ((cInt = stdout.read()) == -1) {
                throw new IOException("End of stream reached");
            }
            outputBuf.write(cInt);
            outputBufStr = outputBuf.toString();
            char c = (char)cInt;
            switch (c) {
                case '\r': {
                    CifsTelnetConnection.handleReceivedLine(outputBuf, outputBufStr, toCallersStdout);
                    break;
                }
                case '\n': {
                    if (lastCharWasCr) break;
                    CifsTelnetConnection.handleReceivedLine(outputBuf, outputBufStr, toCallersStdout);
                    break;
                }
                case '[': {
                    if (!lastCharWasEsc) break;
                    throw new RuntimeIOException("VT100/ANSI escape sequence found in output stream. Please configure the Windows Telnet server to use stream mode (tlntadmn config mode=stream).");
                }
            }
            lastCharWasCr = c == '\r';
            boolean bl = lastCharWasEsc = c == '\u001b';
            if (unexpectedString == null || outputBufStr.length() < unexpectedString.length() || !(s = outputBufStr.substring(outputBufStr.length() - unexpectedString.length(), outputBufStr.length())).equals(unexpectedString)) continue;
            logger.debug("Unexpected string [{}] found in Windows Telnet output", (Object)unexpectedString);
            throw new IOException(String.format("Unexpected string [%s] found in Windows Telnet output", unexpectedString));
        } while (outputBufStr.length() < expectedString.length() || !(s = outputBufStr.substring(outputBufStr.length() - expectedString.length(), outputBufStr.length())).equals(expectedString));
        logger.debug("Expected string [{}] found in Windows Telnet output", (Object)expectedString);
    }

    private static void handleReceivedLine(ByteArrayOutputStream outputBuf, String outputBufStr, PipedOutputStream toCallersStdout) throws IOException {
        if (!outputBufStr.contains(DETECTABLE_WINDOWS_PROMPT)) {
            toCallersStdout.write(outputBuf.toByteArray());
            toCallersStdout.flush();
        }
        outputBuf.reset();
    }

    private static void send(OutputStream stdin, String lineToSend) throws IOException {
        byte[] bytesToSend = (lineToSend + "\r\n").getBytes();
        stdin.write(bytesToSend);
        stdin.flush();
    }
}

