/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.event.EventCallback;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.Registry;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.TaskRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javassist.util.proxy.ProxyObjectInputStream;
import javassist.util.proxy.ProxyObjectOutputStream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.core.context.SecurityContextHolder;

public class ArchivingTaskRegistry
implements TaskRegistry {
    @Autowired
    private TaskArchive taskArchive;
    @Autowired
    private RepositoryService repositoryService;
    private File recoveryFile;
    private int recoveryFileWritingIntervalMillis;
    private Registry registry = new Registry();
    private EventCallback<Task.TaskStateChangeEvent> taskArchivingCallback;
    private Timer recoveryFileWritingTimer;
    private static final Logger logger = LoggerFactory.getLogger(ArchivingTaskRegistry.class);

    @Required
    public void setRecoveryFile(File recoveryFile) {
        this.recoveryFile = recoveryFile;
    }

    @Required
    public void setRecoveryFileWritingIntervalMillis(int recoveryFileWritingIntervalMillis) {
        this.recoveryFileWritingIntervalMillis = recoveryFileWritingIntervalMillis;
    }

    @Override
    public String registerTask(Task task) {
        String uuid = UUID.randomUUID().toString();
        task.setId(uuid);
        this.registry.register(task);
        return uuid;
    }

    @Override
    public Task getTask(String id) {
        return this.registry.retrieve(id);
    }

    @Override
    public void cancelTask(String id) {
        Task task = this.getTask(id);
        if (task.isReadyForExecution() || task.getState() == Task.State.PENDING) {
            boolean moveToArchive = false;
            if (task.getState().equals((Object)Task.State.STOPPED)) {
                moveToArchive = true;
            }
            task.cancel();
            if (moveToArchive) {
                this.moveTaskFromRegistryToArchive(task);
            }
            this.registry.remove(id);
        }
    }

    @Override
    public Collection<Task> getTasks() {
        return this.registry.tasks();
    }

    @Override
    public List<Task> getIncompleteTasksForUser(String username) {
        logger.debug("Finding incomplete tasks for user [{}]", (Object)username);
        ArrayList myTasks = Lists.newArrayList();
        for (Task eachTask : this.getAllIncompleteTasks()) {
            if (!eachTask.getOwner().equals(username)) continue;
            myTasks.add(eachTask);
        }
        logger.debug("Returning [{}] tasks", (Object)myTasks.size());
        return myTasks;
    }

    @Override
    public List<Task> getAllIncompleteTasks() {
        logger.debug("Finding all incomplete tasks");
        ArrayList myTasks = Lists.newArrayList();
        for (Task eachTask : this.registry.tasks()) {
            logger.debug("Considering task {}", (Object)eachTask);
            if (!eachTask.getState().equals((Object)Task.State.PENDING) && !eachTask.getState().equals((Object)Task.State.QUEUED) && !eachTask.getState().equals((Object)Task.State.STOPPED) && !eachTask.getState().equals((Object)Task.State.EXECUTING)) continue;
            logger.debug("Returning task [{}] because it's PENDING, STOPPED or EXECUTING", (Object)eachTask);
            myTasks.add(eachTask);
        }
        logger.debug("Returning [{}] tasks", (Object)myTasks.size());
        return myTasks;
    }

    @Override
    public void assignTask(String taskId, String owner) {
        logger.debug("Assigning task [{}] to owner [{}]", (Object)taskId, (Object)owner);
        Task task = this.getTask(taskId);
        task.setOwner(owner);
    }

    @Override
    public void assignMyTask(String taskId, String owner) {
        Task task = this.getTask(taskId);
        if (!task.getOwner().equals(SecurityContextHolder.getContext().getAuthentication().getName())) {
            throw PermissionDeniedException.withMessage("You are not the current owner of task " + taskId);
        }
        this.assignTask(taskId, owner);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.loadTasksFromRecoveryFile();
        this.registerTaskArchivingCallback();
        this.startRecoveryFileWritingTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTasksFromRecoveryFile() {
        if (this.recoveryFile != null && this.recoveryFile.exists()) {
            try {
                ProxyObjectInputStream recoveryIn = new ProxyObjectInputStream((InputStream)new FileInputStream(this.recoveryFile));
                try {
                    this.registry.recover((ObjectInputStream)recoveryIn);
                    this.postprocessTaskRegistryAfterRecovery();
                }
                finally {
                    recoveryIn.close();
                }
            }
            catch (ClassNotFoundException exc) {
                logger.error("Cannot load tasks from recovery file " + this.recoveryFile, (Throwable)exc);
            }
            catch (IOException exc) {
                logger.error("Cannot load tasks from recovery file " + this.recoveryFile, (Throwable)exc);
            }
        }
    }

    private void postprocessTaskRegistryAfterRecovery() {
        Iterator<Task> tasksIterator = this.registry.tasks().iterator();
        if (tasksIterator.hasNext()) {
            logger.info("Recovering tasks after server crash");
            while (tasksIterator.hasNext()) {
                Task nextTask = tasksIterator.next();
                Task.State taskState = nextTask.getState();
                if (taskState == Task.State.PENDING) {
                    logger.info("Removing {} task {}", (Object)taskState, (Object)nextTask.getId());
                    tasksIterator.remove();
                    continue;
                }
                logger.info("Recovering {} task {}", (Object)taskState, (Object)nextTask.getId());
                this.setDepedenciesInTask(nextTask);
                nextTask.processAfterRecovery();
            }
            logger.info("Recovered tasks after server crash");
        }
    }

    private void setDepedenciesInTask(Task eachTask) {
        DirectFieldAccessor directFieldAccessor;
        if (!eachTask.getState().equals((Object)Task.State.PENDING) && (directFieldAccessor = new DirectFieldAccessor((Object)eachTask)).isWritableProperty("repositoryService")) {
            directFieldAccessor.setPropertyValue("repositoryService", (Object)this.repositoryService);
        }
    }

    @Override
    public void destroy() {
        this.stopRecoveryFileWritingTimer();
        this.writeRecoveryFile();
        this.deregisterTaskArchivingCallback();
    }

    private void registerTaskArchivingCallback() {
        this.taskArchivingCallback = new EventCallback<Task.TaskStateChangeEvent>(){

            @Override
            public void receive(Task.TaskStateChangeEvent event) {
                Task task = event.getTask();
                if (task.getState().equals((Object)Task.State.DONE)) {
                    ArchivingTaskRegistry.this.moveTaskFromRegistryToArchive(task);
                }
            }
        };
        EventBus.registerForEvent(Task.TaskStateChangeEvent.class, this.taskArchivingCallback);
    }

    private void deregisterTaskArchivingCallback() {
        EventBus.deregisterForEvent(Task.TaskStateChangeEvent.class, this.taskArchivingCallback);
    }

    private void startRecoveryFileWritingTimer() {
        this.recoveryFileWritingTimer = new Timer(ArchivingTaskRegistry.class.getName() + "#recoveryFileWritingTimer", true);
        this.recoveryFileWritingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ArchivingTaskRegistry.this.writeRecoveryFile();
            }
        }, this.recoveryFileWritingIntervalMillis, (long)this.recoveryFileWritingIntervalMillis);
    }

    private void stopRecoveryFileWritingTimer() {
        this.recoveryFileWritingTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void writeRecoveryFile() {
        block8: {
            if (this.recoveryFile != null) {
                try {
                    if (this.registry.hasInProgressTasks()) {
                        logger.debug("Writing task recovery file.");
                        File recoveryTemp = new File(this.recoveryFile.getParentFile(), "recovery.tmp");
                        ProxyObjectOutputStream recoveryOut = new ProxyObjectOutputStream((OutputStream)new FileOutputStream(recoveryTemp));
                        try {
                            this.registry.writeRecovery((ObjectOutputStream)recoveryOut);
                        }
                        finally {
                            recoveryOut.close();
                        }
                        this.deleteRecoveryFile();
                        Files.move((File)recoveryTemp, (File)this.recoveryFile);
                        break block8;
                    }
                    this.deleteRecoveryFile();
                }
                catch (IOException exc) {
                    logger.error("Cannot write task registry recovery file", (Throwable)exc);
                }
            }
        }
    }

    protected void deleteRecoveryFile() {
        if (this.recoveryFile.exists()) {
            try {
                Files.deleteRecursively((File)this.recoveryFile);
            }
            catch (IOException e) {
                logger.error("Could not delete {}", (Object)this.recoveryFile, (Object)e);
            }
        }
    }

    private void moveTaskFromRegistryToArchive(final Task task) {
        Preconditions.checkNotNull((Object)task.getOwnerCredentials(), (Object)("Cannot archive task " + task.getId() + " because it has no owner"));
        SecurityTemplate.executeAs(task.getOwnerCredentials(), new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                if (task instanceof DeploymentTask) {
                    ArchivingTaskRegistry.this.taskArchive.archiveTask((DeploymentTask)task);
                }
                ArchivingTaskRegistry.this.registry.remove(task.getId());
                return null;
            }
        });
    }

    @Override
    public TaskArchive getTaskArchive() {
        return this.taskArchive;
    }
}

