/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.specimpl.RequestImpl;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ContextParameterInjector
implements ValueInjector {
    private Class type;
    private ResteasyProviderFactory factory;

    public ContextParameterInjector(Class type, ResteasyProviderFactory factory) {
        this.type = type;
        this.factory = factory;
    }

    @Override
    public Object inject(HttpRequest request, HttpResponse response) {
        if (this.type.equals(HttpHeaders.class)) {
            return request.getHttpHeaders();
        }
        if (this.type.equals(UriInfo.class)) {
            return request.getUri();
        }
        if (this.type.equals(Request.class)) {
            return new RequestImpl(request);
        }
        if (this.type.equals(HttpRequest.class)) {
            return request;
        }
        if (this.type.equals(Providers.class)) {
            return this.factory;
        }
        return ResteasyProviderFactory.getContextData(this.type);
    }

    @Override
    public Object inject() {
        if (this.type.equals(Providers.class)) {
            return this.factory;
        }
        if (!this.type.isInterface()) {
            Object delegate = ResteasyProviderFactory.getContextData(this.type);
            if (delegate != null) {
                return delegate;
            }
            throw new RuntimeException("Illegal to inject a non-interface type into a singleton");
        }
        Class[] intfs = new Class[]{this.type};
        return Proxy.newProxyInstance(this.type.getClassLoader(), intfs, (InvocationHandler)new GenericDelegatingProxy());
    }

    private class GenericDelegatingProxy
    implements InvocationHandler {
        private GenericDelegatingProxy() {
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            try {
                Object delegate = ResteasyProviderFactory.getContextData(ContextParameterInjector.this.type);
                if (delegate == null) {
                    throw new LoggableFailure("Unable to find contextual data of type: " + ContextParameterInjector.this.type.getName());
                }
                return method.invoke(delegate, objects);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
    }
}

