/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ObjectFactory;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.api.legacy.FullTaskInfo;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import java.util.List;

@CliObject(name="deployment")
@ClassHelp(description="Perform tasks related to setting up deployments")
public class DeploymentClient
extends DocumentedObject {
    private final DeploymentService deploymentService;
    private final TaskService taskService;

    public DeploymentClient() {
        this.deploymentService = null;
        this.taskService = null;
    }

    public DeploymentClient(ProxiesInstance proxies) {
        this.deploymentService = proxies.getDeployment();
        this.taskService = proxies.getTaskRegistry();
    }

    @MethodHelp(description="Prepare an initial deployment of a version to an environment", parameters={@ParameterHelp(name="version", description="The source deployment package that is to be deployed"), @ParameterHelp(name="environment", description="The environment that you want to deploy to")}, returns="A deployment that can be edited further")
    public Deployment prepareInitial(String version, String environment) {
        return this.deploymentService.prepareInitial(version, environment);
    }

    @MethodHelp(description="Prepare an upgrade deployment of an existing deployed application", parameters={@ParameterHelp(name="version", description="The source deployment package that is to be deployed"), @ParameterHelp(name="deployedApplication", description="The deployed application that should be upgraded")}, returns="A deployment that can be edited further, with the deployed configuration items upgraded")
    public Deployment prepareUpgrade(String version, String deployedApplication) {
        return this.deploymentService.prepareUpdate(version, deployedApplication);
    }

    @MethodHelp(description="Generate all default deployed configuration items for deployment", parameters={@ParameterHelp(name="deployment", description="The deployment to generate all the deployed configuration items for")}, returns="The deployment updated with all the generated deployed configuration items")
    public Deployment generateAllDeployeds(Deployment deployment) {
        return this.deploymentService.generateAllDeployeds(deployment);
    }

    @MethodHelp(description="Generate default deployed configuration items for only the passed in deployables.", parameters={@ParameterHelp(name="deployables", description="The list of a deployable ids"), @ParameterHelp(name="deployment", description="The deployment to generate the deployed configuration items for")}, returns="The deployment updated with all the generated deployed configuration items")
    public Deployment generateSelectedDeployeds(List<String> deployables, Deployment deployment) {
        return this.deploymentService.generateSelectedDeployeds(deployables, deployment);
    }

    @MethodHelp(description="Generate default deployed configuration item for the deployable to the container", parameters={@ParameterHelp(name="deployable", description="The deployable to deploy"), @ParameterHelp(name="container", description="The container to deploy to"), @ParameterHelp(name="deployment", description="The deployment to generate the deployed configuration item for")}, returns="The deployment updated with the generated deployed configuration item")
    public Deployment generateSingleDeployed(String deployable, String container, Deployment deployment) {
        return this.deploymentService.generateSingleDeployed(deployable, container, null, deployment);
    }

    @MethodHelp(description="Generate default deployed configuration item for the deployable to the container of the specified type", parameters={@ParameterHelp(name="deployable", description="The deployable to deploy"), @ParameterHelp(name="container", description="The container to deploy to"), @ParameterHelp(name="type", description="The type of the deployed configuration item to generate"), @ParameterHelp(name="deployment", description="The deployment to generate the deployed configuration item for")}, returns="The deployment updated with the generated deployed configuration item")
    public Deployment generateSingleDeployed(String deployable, String container, String type, Deployment deployment) {
        return this.deploymentService.generateSingleDeployed(deployable, container, ObjectFactory.toType(type), deployment);
    }

    @MethodHelp(description="Validate the deployment that you want to perform", parameters={@ParameterHelp(name="deployment", description="The deployment to validate")}, returns="The validated deployment with added validation messages")
    public Deployment validate(Deployment deployment) {
        return this.deploymentService.validate(deployment);
    }

    @MethodHelp(description="Prepare the deployment, readying it for execution", parameters={@ParameterHelp(name="deployment", description="The deployment to perform")}, returns="The task information needed to start the deployment")
    public FullTaskInfo deploy(Deployment deployment) {
        String taskId = this.deploymentService.createTask(deployment);
        return new FullTaskInfo(this.taskService.getSteps(taskId));
    }

    @MethodHelp(description="Undeploy the deployed application", parameters={@ParameterHelp(name="deployedApplication", description="The deployed application to undeploy")}, returns="The task information needed to start the undeployment")
    public FullTaskInfo undeploy(String deployedApplication) {
        Deployment deployment = this.deploymentService.prepareUndeploy(deployedApplication);
        String taskId = this.deploymentService.createTask(deployment);
        return new FullTaskInfo(this.taskService.getSteps(taskId));
    }

    @MethodHelp(description="Rollback a deployment task. The specified task will be canceled and archived and a new rollback task will be created that reverts all changes of the specified deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the deployment task to rollback")}, returns="The task id of the created rollback task")
    public String rollbackTask(String taskId) {
        return this.deploymentService.rollback(taskId);
    }

    public String createTask(Deployment deployment) {
        return this.deploymentService.createTask(deployment);
    }
}

