/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.LocalMethodDescriptor;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.SyntheticHelper;
import com.xebialabs.deployit.booter.local.ValidationRuleConverter;
import com.xebialabs.deployit.booter.local.VerificationConverter;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.utils.ClassUtils;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.TypeVerification;
import com.xebialabs.deployit.plugin.api.reflect.VerificationContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Prefix;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class LocalDescriptor
implements Descriptor {
    static final String PLACEHOLDERS_FIELD = "placeholders";
    private Type type;
    private Class<? extends ConfigurationItem> clazz;
    private String description;
    private Metadata.ConfigurationItemRoot root;
    private List<Type> superclasses = Lists.newArrayList();
    private Set<Type> interfaces = Sets.newHashSet();
    private boolean virtual = false;
    private Map<String, PropertyDescriptor> properties = Maps.newLinkedHashMap();
    private Type deployableType;
    private Type containerType;
    private Type generatedDeployableType;
    private Type generatedDeployableBase;
    private String generatedDeployableDescription;
    private boolean hierarchyInitialized = false;
    private Map<String, MethodDescriptor> controlTasks = Maps.newHashMap();
    private List<Validator<ConfigurationItem>> validators = Lists.newArrayList();
    private transient List<TypeVerification> verifications = Lists.newArrayList();
    private Field syntheticPropertiesField;
    private boolean isInspectable;
    private static final Logger logger = LoggerFactory.getLogger(LocalDescriptor.class);

    private LocalDescriptor(Class<? extends ConfigurationItem> clazz) {
        this.type = Type.valueOf(clazz);
        this.virtual = clazz.isInterface();
        this.clazz = clazz;
    }

    private LocalDescriptor(Type type) {
        this.type = type;
    }

    static Descriptor from(Class<? extends ConfigurationItem> clazz) {
        try {
            LocalDescriptor descriptor = new LocalDescriptor(clazz);
            descriptor.initMetadata();
            descriptor.scanClass();
            return descriptor;
        }
        catch (RuntimeException e) {
            throw new DescriptorException("Could not create descriptor for: " + clazz.getName(), e);
        }
        catch (Throwable t) {
            throw new DescriptorError("Could not create descriptor for: " + clazz.getName(), t);
        }
    }

    private void initMetadata() {
        Annotation[] declaredAnnotations;
        if (this.virtual) {
            return;
        }
        boolean directlyAnnotated = false;
        for (Annotation declaredAnnotation : declaredAnnotations = this.clazz.getDeclaredAnnotations()) {
            if (!declaredAnnotation.annotationType().equals(Metadata.class)) continue;
            directlyAnnotated = true;
        }
        Metadata annotation = (Metadata)Preconditions.checkNotNull((Object)this.clazz.getAnnotation(Metadata.class), (Object)("Class " + this.clazz.getName() + " or one of its ancestors does not have a @Metadata annotation"));
        this.description = annotation.description();
        this.root = annotation.root();
        this.isInspectable = annotation.inspectable();
        this.virtual = directlyAnnotated && annotation.virtual() || Modifier.isAbstract(this.clazz.getModifiers());
    }

    private void scanClass() {
        this.findProperties();
        this.findControlTasks();
        this.findInterfaces();
        this.findValidations();
        this.findVerifications();
        Class<? extends ConfigurationItem> superclass = this.clazz.getSuperclass();
        if (superclass != null && ConfigurationItem.class.isAssignableFrom(superclass)) {
            Type supertype = Type.valueOf(superclass);
            this.addSuperClass(supertype);
        }
        this.initDeployableAndContainerTypes();
    }

    private void findVerifications() {
        for (Annotation annotation : this.clazz.getAnnotations()) {
            if (!VerificationConverter.isVerification(annotation)) continue;
            this.verifications.add(VerificationConverter.makeVerification(annotation));
        }
    }

    private void findValidations() {
        for (Annotation annotation : this.clazz.getAnnotations()) {
            if (!ValidationRuleConverter.isRule(annotation)) continue;
            Validator<?> v = ValidationRuleConverter.makeRule(annotation);
            this.validators.add(v);
        }
    }

    private void findControlTasks() {
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ControlTask.class)) continue;
            MethodDescriptor from = LocalMethodDescriptor.from((Descriptor)this, method);
            this.addControlTask(from);
        }
    }

    private void findProperties() {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            PropertyDescriptor propertyDescriptor = LocalPropertyDescriptor.from(this, field);
            this.addProperty(propertyDescriptor);
        }
    }

    private void findInterfaces() {
        Class<?>[] clazzInterfaces = this.clazz.getInterfaces();
        ArrayList allInterfacesFound = Lists.newArrayList();
        this.findAllSuperInterfaces(clazzInterfaces, allInterfacesFound);
        for (Class clazzInterface : allInterfacesFound) {
            if (!clazzInterface.getPackage().isAnnotationPresent(Prefix.class)) continue;
            this.addInterface(Type.valueOf((Class)clazzInterface));
        }
    }

    private void findAllSuperInterfaces(Class<?>[] childInterfaces, List<Class<?>> allInterfacesFound) {
        for (Class<?> childInterface : childInterfaces) {
            allInterfacesFound.add(childInterface);
            this.findAllSuperInterfaces(childInterface.getInterfaces(), allInterfacesFound);
        }
    }

    private void initDeployableAndContainerTypes() {
        if (Deployed.class.isAssignableFrom(this.clazz)) {
            List<Class<?>> typeArguments = ClassUtils.getActualTypeArguments(this.clazz, Deployed.class);
            Preconditions.checkArgument((typeArguments.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly a Deployable and a Container, but got %s", (Object[])new Object[]{typeArguments});
            Class<?> deployableClass = typeArguments.get(0);
            if (deployableClass != null) {
                Preconditions.checkArgument((boolean)Deployable.class.isAssignableFrom(deployableClass), (Object)"Expected first item to be a deployable");
                this.deployableType = Type.valueOf(deployableClass);
            } else {
                this.deployableType = null;
            }
            Class<?> containerClass = typeArguments.get(1);
            if (containerClass != null) {
                Preconditions.checkArgument((boolean)Container.class.isAssignableFrom(containerClass), (Object)"Expected second item to be a container");
                this.containerType = Type.valueOf(containerClass);
            } else {
                this.containerType = null;
            }
        } else {
            this.deployableType = null;
            this.containerType = null;
        }
    }

    static Descriptor from(Element typeElement) {
        Type type = SyntheticHelper.getRequiredTypeAttribute(typeElement, "type");
        LocalDescriptor descriptor = new LocalDescriptor(type);
        descriptor.initSynthetic(typeElement);
        return descriptor;
    }

    private void initSynthetic(Element typeElement) {
        this.description = SyntheticHelper.getOptionalStringAttribute(typeElement, "description", "Description unavailable");
        this.virtual = SyntheticHelper.getOptionalBooleanAttribute(typeElement, "virtual", false);
        this.isInspectable = SyntheticHelper.getOptionalBooleanAttribute(typeElement, "inspectable", false);
        Type superType = SyntheticHelper.getRequiredTypeAttribute(typeElement, "extends");
        this.addSuperClass(superType);
        this.parseSyntheticDeployableAndContainerType(typeElement);
        this.parseProperties(typeElement);
        this.parseControlTasks(typeElement);
        this.parseValidators(typeElement);
        this.parseVerifications(typeElement);
    }

    private void parseVerifications(Element typeElement) {
        SyntheticHelper.forEach(SyntheticHelper.childByName(typeElement, (Predicate<String>)Predicates.equalTo((Object)"verification")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                LocalDescriptor.this.verifications.add(VerificationConverter.makeVerification(element, LocalDescriptor.this.type));
            }
        });
    }

    private void parseValidators(Element typeElement) {
        SyntheticHelper.forEach(SyntheticHelper.childByName(typeElement, (Predicate<String>)Predicates.equalTo((Object)"rule")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                LocalDescriptor.this.validators.add(ValidationRuleConverter.makeRule(element, LocalDescriptor.this.type));
            }
        });
    }

    private void parseSyntheticDeployableAndContainerType(Element typeElement) {
        this.deployableType = SyntheticHelper.getOptionalTypeAttribute(typeElement, "deployable-type");
        this.containerType = SyntheticHelper.getOptionalTypeAttribute(typeElement, "container-type");
        Iterator<Element> generateElements = SyntheticHelper.childByName(typeElement, (Predicate<String>)Predicates.equalTo((Object)"generate-deployable"));
        if (generateElements.hasNext()) {
            Element generateDeployable = generateElements.next();
            this.generatedDeployableType = SyntheticHelper.getRequiredTypeAttribute(generateDeployable, "type");
            this.generatedDeployableBase = SyntheticHelper.getRequiredTypeAttribute(generateDeployable, "extends");
            this.generatedDeployableDescription = SyntheticHelper.getOptionalStringAttribute(generateDeployable, "description", "Description unavailable");
        }
    }

    void parseTypeModification(Element element) {
        this.parseProperties(element);
        this.parseControlTasks(element);
        this.parseValidators(element);
        this.parseVerifications(element);
    }

    private void parseControlTasks(Element element) {
        SyntheticHelper.forEach(SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"method")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                MethodDescriptor controlTask = LocalMethodDescriptor.from((Descriptor)LocalDescriptor.this, element);
                LocalDescriptor.this.verifyNewControlTask(controlTask);
                LocalDescriptor.this.addControlTask(controlTask);
            }
        });
    }

    private void parseProperties(Element element) {
        SyntheticHelper.forEach(SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"property")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                String name = SyntheticHelper.getRequiredStringAttribute(element, "name");
                LocalPropertyDescriptor newDesc = LocalPropertyDescriptor.from(LocalDescriptor.this, element);
                PropertyDescriptor oldDesc = (PropertyDescriptor)LocalDescriptor.this.properties.get(name);
                if (oldDesc != null) {
                    newDesc.overrideWith((LocalPropertyDescriptor)oldDesc);
                }
                LocalDescriptor.this.addProperty(newDesc);
            }
        });
    }

    private void verifyNewControlTask(MethodDescriptor controlTask) {
        if (this.controlTasks.containsKey(controlTask.getName())) {
            throw new IllegalStateException("Cannot override existing Control Task [" + controlTask.getFqn() + "] with a synthetic one.");
        }
    }

    static Descriptor from(LocalDescriptor deployedDescriptor) {
        LocalDescriptor deployableDescriptor = new LocalDescriptor(deployedDescriptor.generatedDeployableType);
        deployableDescriptor.addSuperClass(deployedDescriptor.generatedDeployableBase);
        deployableDescriptor.initDeployableFromDeployed(deployedDescriptor, deployedDescriptor.generatedDeployableDescription);
        return deployableDescriptor;
    }

    private void initDeployableFromDeployed(Descriptor deployedDescriptor, String generatedDeployableDescription) {
        this.description = generatedDeployableDescription == null || generatedDeployableDescription.equals("Description unavailable") ? deployedDescriptor.getDescription() + " (deployable)" : generatedDeployableDescription;
        for (PropertyDescriptor pd : deployedDescriptor.getPropertyDescriptors()) {
            boolean isReferenceField;
            String name = pd.getName();
            boolean isUdmField = name.equals("deployable") || name.equals("container") || name.equals(PLACEHOLDERS_FIELD);
            PropertyKind kind = pd.getKind();
            boolean bl = isReferenceField = kind == PropertyKind.CI || kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
            if (isUdmField || isReferenceField || pd.isHidden()) continue;
            this.addProperty(LocalPropertyDescriptor.generateDeployableFrom(this, pd));
        }
    }

    void initHierarchy() {
        if (this.hierarchyInitialized) {
            return;
        }
        if (!this.superclasses.isEmpty()) {
            Type toInitFrom = this.superclasses.get(0);
            do {
                LocalDescriptor superDesc;
                if ((superDesc = (LocalDescriptor)LocalDescriptorRegistry.getDescriptor((Type)toInitFrom)) == null) {
                    throw new IllegalStateException("Cannot build type hierarchy for " + this.getType() + " because one of its supertypes cannot be found: " + toInitFrom + " not found");
                }
                if (this.root == null) {
                    this.root = superDesc.getRoot();
                }
                if (this.clazz == null) {
                    this.clazz = superDesc.clazz;
                }
                this.inheritPropertyDescriptors(this.properties, superDesc.properties);
                this.inheritControlTasks(this.controlTasks, superDesc.controlTasks);
                this.inheritValidators(this.validators, superDesc.validators);
                for (Type superclass : superDesc.superclasses) {
                    this.addSuperClass(superclass);
                }
                for (Type intf : superDesc.interfaces) {
                    this.addInterface(intf);
                }
                Type type = toInitFrom = superDesc.superclasses.isEmpty() || superDesc.hierarchyInitialized ? null : superDesc.getSuperClasses().get(0);
                if (this.deployableType == null) {
                    this.deployableType = superDesc.getDeployableType();
                }
                if (this.containerType != null) continue;
                this.containerType = superDesc.getContainerType();
            } while (toInitFrom != null);
        }
        if (!this.clazz.isInterface() && !Type.valueOf((String)"api.ValidatedConfigurationItem").equals((Object)this.type)) {
            this.syntheticPropertiesField = ReflectionUtils.searchField(this.clazz, "syntheticProperties");
            this.syntheticPropertiesField.setAccessible(true);
        }
        this.hierarchyInitialized = true;
    }

    void verify(final Verifications verifications) {
        this.verifySyntheticPropertiesField(verifications);
        this.verifyReferenceTypes(verifications);
        this.verifyNonArtifactDoesNotHavePlaceholders(verifications);
        this.verifyArtifactInterfaces(verifications);
        if (!this.isVirtual()) {
            this.verifyJavaClassIsNotAbstract(verifications);
            this.verifyDeployedHasDeployableAndContainerType(verifications);
            this.verifyDeployedHasCorrectInheritance(verifications);
            this.verifyHiddenRequiredPropertiesHaveDefaultValue(verifications);
            this.verifyControlTasks(verifications);
        }
        if (!this.isInspectable()) {
            this.verifyNoInspectionProperties(verifications);
        }
        this.verifyExtendsBaseConfigurationItem(verifications);
        for (TypeVerification verification : this.verifications) {
            verification.verify((Descriptor)this, new VerificationContext(){

                public void error(String message, Object ... params) {
                    verifications.verify(LocalDescriptor.this.type, false, message, params);
                }
            });
        }
    }

    private void verifyExtendsBaseConfigurationItem(Verifications verifications) {
        if (this.clazz != null && !BaseConfigurationItem.class.isAssignableFrom(this.clazz)) {
            Deprecations.deprecated((String)"ConfigurationItem [%s] does not extend BaseConfigurationItem, will be required in Deployit 4.0", (Object[])new Object[]{this.type});
            logger.warn("Concurrent modifications cannot be detected on Configuration Items of type [{}] because is does not extend BaseConfigurationItem.", (Object)this.type);
        }
    }

    private void verifyNoInspectionProperties(Verifications verifications) {
        ArrayList inspectableProperties = Lists.newArrayList((Iterable)Iterables.filter(this.properties.values(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return input.isInspectionProperty();
            }
        }));
        verifications.verify(this.type, inspectableProperties.isEmpty(), "Type [%s] is not inspectable but has @InspectionProperty properties %s", this.type, inspectableProperties);
    }

    private void verifySyntheticPropertiesField(Verifications verifications) {
        verifications.verify(this.type, this.syntheticPropertiesField != null, "Synthetic properties field should be set", new Object[0]);
        if (this.syntheticPropertiesField != null) {
            verifications.verify(this.type, this.syntheticPropertiesField.getType().isAssignableFrom(Map.class), "Synthetic properties field should be Map<String, Object>, not: %s", this.syntheticPropertiesField.getType());
        }
    }

    private void verifyControlTasks(Verifications verifications) {
        for (MethodDescriptor controlTask : this.controlTasks.values()) {
            ((LocalMethodDescriptor)controlTask).verify(verifications);
        }
    }

    private void verifyReferenceTypes(Verifications verifications) {
        for (PropertyDescriptor p : this.properties.values()) {
            PropertyKind kind = p.getKind();
            if (kind != PropertyKind.CI && kind != PropertyKind.SET_OF_CI && kind != PropertyKind.LIST_OF_CI) continue;
            verifications.verify(this.type, this.isValidReferencedType(p.getReferencedType()), "Property %s of type %s refers to non-existing type %s", p.getName(), ((LocalPropertyDescriptor)p).getDeclaringDescriptor().getType(), p.getReferencedType());
        }
    }

    private boolean isValidReferencedType(Type referencedType) {
        if (LocalDescriptorRegistry.exists((Type)referencedType)) {
            return true;
        }
        for (Descriptor d : LocalDescriptorRegistry.getDescriptors()) {
            if (d.getSuperClasses().contains(referencedType)) {
                return true;
            }
            if (!d.getInterfaces().contains(referencedType)) continue;
            return true;
        }
        return false;
    }

    private void verifyNonArtifactDoesNotHavePlaceholders(Verifications verifications) {
        if (!this.isAssignableTo(Artifact.class)) {
            for (PropertyDescriptor propertyDescriptor : this.properties.values()) {
                verifications.verify(this.type, !propertyDescriptor.getName().equals(PLACEHOLDERS_FIELD), "Cannot have a field 'placeholders' as 'udm.Artifact' is not implemented.", new Object[0]);
            }
        }
    }

    private void verifyArtifactInterfaces(Verifications verifications) {
        if (this.isAssignableTo(Deployable.class) && this.isAssignableTo(Artifact.class)) {
            verifications.verify(this.type, this.isAssignableTo(SourceArtifact.class), "Implements both 'udm.Deployable' and 'udm.Artifact' interface. Must also implement the 'udm.SourceArtifact' interface", new Object[0]);
            verifications.verify(this.type, this.isAssignableTo(DeployableArtifact.class), "Implements the 'udm.Deployable' and 'udm.Artifact' interface. Must also implement the 'udm.DeployableArtifact' interface", new Object[0]);
        }
        if (this.isAssignableTo(Deployed.class) && this.isAssignableTo(Artifact.class)) {
            verifications.verify(this.type, this.isAssignableTo(DerivedArtifact.class), "Implements the 'udm.Deployed' and 'udm.Artifact' interface. Must also implement the 'udm.DerivedArtifact' interface", new Object[0]);
        }
    }

    private void verifyJavaClassIsNotAbstract(Verifications verifications) {
        verifications.verify(this.type, !Modifier.isAbstract(this.clazz.getModifiers()), "Non-virtual type %s has an abstract Java class %s", this.type, this.clazz.getName());
    }

    private void verifyDeployedHasDeployableAndContainerType(Verifications verifications) {
        Type deployedType = Type.valueOf(Deployed.class);
        if (this.isAssignableTo(deployedType)) {
            verifications.verify(this.type, this.getDeployableType() != null, "Non-virtual type %s is a sub-type of %s but does not have a deployable-type", this.getType(), deployedType);
            verifications.verify(this.type, this.getContainerType() != null, "Non-virtual type %s is a sub-type of %s but does not have a container-type", this.getType(), deployedType);
        }
    }

    private void verifyDeployedHasCorrectInheritance(Verifications verifications) {
        Type deployedType = Type.valueOf(Deployed.class);
        if (this.isAssignableTo(deployedType)) {
            Type directSuperType = this.superclasses.get(0);
            Descriptor superDescriptor = directSuperType.getDescriptor();
            Type superDeployable = superDescriptor.getDeployableType();
            Type superContainer = superDescriptor.getContainerType();
            verifications.verify(this.type, superDeployable == null || this.deployableType.instanceOf(superDeployable), "Type %s inherits from %s<%s, %s> but doesn't have a deployable subtype (%s).", this.type, directSuperType, superDeployable, superContainer, this.deployableType);
            verifications.verify(this.type, superContainer == null || this.containerType.instanceOf(superContainer), "Type %s inherits from %s<%s, %s> but doesn't have a container subtype (%s).", this.type, directSuperType, superDeployable, superContainer, this.containerType);
        }
    }

    private void verifyHiddenRequiredPropertiesHaveDefaultValue(Verifications verifications) {
        for (PropertyDescriptor p : this.properties.values()) {
            if (!p.isHidden() || !p.isRequired()) continue;
            verifications.verify(this.type, p.getDefaultValue() != null, "Hidden required property %s of non-virtual type %s must have a default value", p.getName(), this.getType());
        }
    }

    private void inheritValidators(List<Validator<ConfigurationItem>> dest, List<Validator<ConfigurationItem>> source) {
        dest.addAll(source);
    }

    private void inheritControlTasks(Map<String, MethodDescriptor> dest, Map<String, MethodDescriptor> source) {
        for (Map.Entry<String, MethodDescriptor> sourceEntry : source.entrySet()) {
            if (!dest.containsKey(sourceEntry.getKey())) {
                dest.put(sourceEntry.getKey(), new LocalMethodDescriptor((LocalMethodDescriptor)sourceEntry.getValue(), this));
                continue;
            }
            logger.warn("Not inheriting ControlTask [{}] on [{}]", new Object[]{sourceEntry.getValue().getFqn(), this.type});
        }
    }

    private void inheritPropertyDescriptors(Map<String, PropertyDescriptor> dest, Map<String, PropertyDescriptor> source) {
        LinkedHashMap myDescriptors = Maps.newLinkedHashMap(dest);
        dest.clear();
        for (Map.Entry<String, PropertyDescriptor> sourceEntry : source.entrySet()) {
            if (!myDescriptors.containsKey(sourceEntry.getKey())) {
                dest.put(sourceEntry.getKey(), new LocalPropertyDescriptor((LocalPropertyDescriptor)sourceEntry.getValue(), this));
                continue;
            }
            ((LocalPropertyDescriptor)myDescriptors.get(sourceEntry.getKey())).overrideWith((LocalPropertyDescriptor)sourceEntry.getValue());
        }
        dest.putAll(myDescriptors);
    }

    private void addSuperClass(Type supertype) {
        this.superclasses.add(supertype);
        LocalDescriptorRegistry.registerSubtype(supertype, this.type);
    }

    private void addInterface(Type intf) {
        LocalDescriptorRegistry.registerSubtype(intf, this.type);
        this.interfaces.add(intf);
    }

    private void addProperty(PropertyDescriptor propertyDescriptor) {
        this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
    }

    private void addControlTask(MethodDescriptor from) {
        this.controlTasks.put(from.getName(), from);
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getDescription() {
        return this.description;
    }

    public Metadata.ConfigurationItemRoot getRoot() {
        return this.root;
    }

    public Collection<PropertyDescriptor> getPropertyDescriptors() {
        return this.properties.values();
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.properties.get(name);
    }

    public MethodDescriptor getControlTask(String name) {
        return this.controlTasks.get(name);
    }

    public Collection<MethodDescriptor> getControlTasks() {
        return this.controlTasks.values();
    }

    public boolean isAssignableTo(Class<?> clazz) {
        return this.isAssignableTo(Type.valueOf(clazz));
    }

    public boolean isAssignableTo(Type type) {
        return this.type.isSubTypeOf(type) || this.type.equals((Object)type);
    }

    public List<Type> getSuperClasses() {
        return this.superclasses;
    }

    public Set<Type> getInterfaces() {
        return this.interfaces;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        return this.areEqual(item, other, new HashSet<String>());
    }

    boolean areEqual(ConfigurationItem item, ConfigurationItem other, Set<String> itemsBeingCompared) {
        if (item == null) {
            return other == null;
        }
        if (!this.getType().equals((Object)item.getType()) || !this.getType().equals((Object)other.getType())) {
            return false;
        }
        if (!itemsBeingCompared.add(item.getId())) {
            return true;
        }
        for (PropertyDescriptor pd : this.getPropertyDescriptors()) {
            if (((LocalPropertyDescriptor)pd).areEqual(item, other, itemsBeingCompared)) continue;
            return false;
        }
        return true;
    }

    boolean shouldGenerateDeployableType() {
        return this.generatedDeployableType != null;
    }

    public <T extends ConfigurationItem> T newInstance() {
        if (this.virtual) {
            throw new IllegalArgumentException("Cannot instantiate class for " + this.type + " because it is virtual");
        }
        try {
            Field typeField = ReflectionUtils.searchField(this.clazz, "type");
            typeField.setAccessible(true);
            ConfigurationItem t = this.clazz.newInstance();
            typeField.set(t, this.type);
            this.prefillDefaultProperties(t);
            return (T)t;
        }
        catch (InstantiationException exc) {
            throw new RuntimeException("Cannot instantiate class " + this.clazz.getName(), exc);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException("Cannot instantiate class " + this.clazz.getName(), exc);
        }
    }

    private <T extends ConfigurationItem> void prefillDefaultProperties(T t) {
        for (PropertyDescriptor pd : this.getPropertyDescriptors()) {
            LocalPropertyDescriptor lpd = (LocalPropertyDescriptor)pd;
            if (pd.getDefaultValue() != null) {
                pd.set(t, lpd.getDefaultValue());
                continue;
            }
            pd.set(t, lpd.emptyValue());
        }
    }

    public String toString() {
        return "Descriptor[" + this.type + "]";
    }

    public Type getDeployableType() {
        return this.deployableType;
    }

    public Type getContainerType() {
        return this.containerType;
    }

    Field getSyntheticPropertiesField() {
        return this.syntheticPropertiesField;
    }

    public List<ValidationMessage> validate(final ConfigurationItem ci) {
        final ArrayList messages = Lists.newArrayList();
        for (PropertyDescriptor propertyDescriptor : this.properties.values()) {
            ((LocalPropertyDescriptor)propertyDescriptor).validate(ci, messages);
        }
        for (Validator validator : this.validators) {
            validator.validate((Object)ci, new ValidationContext(){

                public void error(String message, Object ... params) {
                    messages.add(new ValidationMessage(ci.getId(), null, String.format(message, params)));
                }
            });
        }
        return messages;
    }

    public boolean isInspectable() {
        return this.isInspectable;
    }

    private static class DescriptorError
    extends Error {
        public DescriptorError(String s, Throwable e) {
            super(s, e);
        }
    }

    private static class DescriptorException
    extends RuntimeException {
        public DescriptorException(String s, RuntimeException e) {
            super(s, e);
        }
    }
}

