/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.engine.spi.event.TaskCreatedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.tasker.Engine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.ChangeSetBuilder;
import com.xebialabs.deployit.service.deployment.DeployedService;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.deployment.RollbackService;
import com.xebialabs.deployit.service.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.PathParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DeploymentResource
extends AbstractSecuredResource
implements com.xebialabs.deployit.engine.api.DeploymentService {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private DeployedService deployedService;
    @Autowired
    private RollbackService rollbackService;
    @Autowired
    private Engine engine;
    @Autowired
    private Validator validator;
    @Autowired
    private WorkDirFactory workDirFactory;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);

    public Deployment prepareInitial(String versionId, String environmentId) {
        logger.trace("prepareInitial {}, {}", (Object)versionId, (Object)environmentId);
        this.checkPermission(Permission.DEPLOY_INITIAL, environmentId);
        Checks.checkNotNull((Object)versionId, (String)"version");
        Checks.checkNotNull((Object)environmentId, (String)"environment");
        ConfigurationItem version = this.repositoryService.read(versionId);
        ConfigurationItem environment = this.repositoryService.read(environmentId);
        Checks.checkArgument((boolean)(version instanceof Version), (String)"%s is not a Version", (Object[])new Object[]{versionId});
        Checks.checkArgument((boolean)(environment instanceof Environment), (String)"%s is not an Environment", (Object[])new Object[]{environmentId});
        Deployment deployment = DeploymentResource.createDeployment((Version)version, (Environment)environment);
        return deployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deployment prepareUpdate(String newVersionId, String deployedApplicationId) {
        logger.trace("prepareUpgrade {}, {}", (Object)newVersionId, (Object)deployedApplicationId);
        Checks.checkNotNull((Object)newVersionId, (String)"version");
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        WorkDir existingWorkDir = this.workDirFactory.newWorkDir();
        WorkDir newWorkDir = this.workDirFactory.newWorkDir();
        try {
            ConfigurationItem deployedApplication = this.repositoryService.read(deployedApplicationId, existingWorkDir);
            Checks.checkArgument((boolean)(deployedApplication instanceof DeployedApplication), (String)"%s is not a DeployedApplication", (Object[])new Object[]{deployedApplicationId});
            Environment env = ((DeployedApplication)deployedApplication).getEnvironment();
            this.checkPermission(Permission.DEPLOY_UPGRADE, env.getId());
            ConfigurationItem newVersion = this.repositoryService.read(newVersionId, newWorkDir);
            Checks.checkArgument((boolean)(newVersion instanceof Version), (String)"%s is not a Version", (Object[])new Object[]{newVersionId});
            ListMultimap upgradedDeployeds = this.deployedService.generateUpgradedDeployeds((Version)newVersion, (DeployedApplication)deployedApplication);
            DeployedApplication deplApp = (DeployedApplication)deployedApplication;
            deplApp.setDeployeds((Set)Sets.newHashSet());
            deplApp.setVersion((Version)newVersion);
            Deployment deployment = DeploymentResource.createDeployment(deplApp, Deployment.DeploymentType.UPDATE);
            deployment.setDeployeds(DeploymentResource.convertDeployeds((ListMultimap<Boolean, ConfigurationItem>)upgradedDeployeds));
            Deployment deployment2 = deployment;
            return deployment2;
        }
        finally {
            existingWorkDir.delete();
            newWorkDir.delete();
        }
    }

    public Deployment prepareUndeploy(String deployedApplicationId) {
        logger.trace("prepareUndeployApplication {}", (Object)deployedApplicationId);
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        ConfigurationItem application = this.repositoryService.read(deployedApplicationId);
        Checks.checkArgument((boolean)(application instanceof DeployedApplication), (String)"%s is not a DeployedApplication", (Object[])new Object[]{deployedApplicationId});
        DeployedApplication deployedApplication = (DeployedApplication)application;
        this.checkPermission(Permission.UNDEPLOY, deployedApplication.getEnvironment().getId());
        Deployment deployment = DeploymentResource.createDeployment(deployedApplication, Deployment.DeploymentType.UNDEPLOYMENT);
        return deployment;
    }

    public Deployment generateAllDeployeds(Deployment deployment) {
        logger.trace("generateAllDeployeds {}", (Object)deployment);
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        DeployedApplication deployedApplication = (DeployedApplication)deployment.getDeployedApplication();
        this.checkPermission(Permission.DEPLOY_INITIAL, deployedApplication.getEnvironment().getId());
        Version version = deployedApplication.getVersion();
        Environment environment = deployedApplication.getEnvironment();
        ListMultimap initialDeployeds = this.deployedService.generateAllDeployeds(version, environment);
        deployment.addAll(DeploymentResource.convertDeployeds((ListMultimap<Boolean, ConfigurationItem>)initialDeployeds));
        return deployment;
    }

    private static List<ConfigurationItem> convertDeployeds(ListMultimap<Boolean, ConfigurationItem> initialDeployeds) {
        ArrayList deployeds = Lists.newArrayList();
        deployeds.addAll(initialDeployeds.get((Object)true));
        for (ConfigurationItem configurationItem : initialDeployeds.get((Object)false)) {
            ValidatedConfigurationItem vci = new ValidatedConfigurationItem(configurationItem);
            vci.getValidations().add(new ValidationMessage(configurationItem.getId(), "source", "The deployable for this deployed is missing from the package."));
            deployeds.add(vci);
        }
        return deployeds;
    }

    public Deployment generateSelectedDeployeds(List<String> deployableIds, Deployment deployment) {
        logger.trace("generateSelectedDeployeds {}, {}", deployableIds, (Object)deployment);
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        DeployedApplication deployedApplication = (DeployedApplication)deployment.getDeployedApplication();
        this.checkPermission(Permission.DEPLOY_INITIAL, deployedApplication.getEnvironment().getId());
        Version version = deployedApplication.getVersion();
        Environment environment = deployedApplication.getEnvironment();
        Checks.checkArgument((deployableIds.size() > 0 ? 1 : 0) != 0, (String)"Should select at least one deployable to generate a deployed", (Object[])new Object[0]);
        ImmutableMap deployables = Maps.uniqueIndex((Iterable)version.getDeployables(), (Function)new Function<Deployable, String>(){

            public String apply(Deployable input) {
                return input.getId();
            }
        });
        ArrayList deployableCIs = Lists.newArrayList();
        for (String id : deployableIds) {
            Checks.checkArgument((boolean)deployables.containsKey(id), (String)"All sources should be from same package", (Object[])new Object[0]);
            deployableCIs.add(deployables.get(id));
        }
        ListMultimap selectedDeployeds = this.deployedService.generateSelectedDeployeds((List)deployableCIs, environment);
        deployment.addAll(DeploymentResource.convertDeployeds((ListMultimap<Boolean, ConfigurationItem>)selectedDeployeds));
        return deployment;
    }

    public Deployment generateSingleDeployed(final String deployableId, final String containerId, Type deployedType, Deployment deployment) {
        logger.debug("Creating explicit deployed for [{}] and [{}]", (Object)deployableId, (Object)containerId);
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        DeployedApplication deployedApplication = (DeployedApplication)deployment.getDeployedApplication();
        this.checkPermission(Permission.DEPLOY_INITIAL, deployedApplication.getEnvironment().getId());
        Version version = deployedApplication.getVersion();
        Environment environment = deployedApplication.getEnvironment();
        Checks.checkNotNull((Object)deployableId, (String)"deployable");
        Checks.checkNotNull((Object)containerId, (String)"container");
        ConfigurationItem deployable = (ConfigurationItem)Iterables.find((Iterable)version.getDeployables(), (Predicate)new Predicate<Deployable>(){

            public boolean apply(Deployable input) {
                return input.getId().equals(deployableId);
            }
        });
        Checks.checkArgument((boolean)(deployable instanceof Deployable), (String)"%s should be a Deployable.", (Object[])new Object[]{deployableId});
        ConfigurationItem container = (ConfigurationItem)Iterables.find((Iterable)environment.getMembers(), (Predicate)new Predicate<Container>(){

            public boolean apply(Container input) {
                return input.getId().equals(containerId);
            }
        });
        Checks.checkArgument((boolean)(container instanceof Container), (String)"%s should be a Container.", (Object[])new Object[]{containerId});
        ListMultimap deployeds = this.deployedService.createSelectedDeployed((Deployable)deployable, (Container)container, deployedType, environment);
        deployment.addAll(DeploymentResource.convertDeployeds((ListMultimap<Boolean, ConfigurationItem>)deployeds));
        return deployment;
    }

    public Deployment validate(Deployment deployment) {
        if (!this.validateDeploymentWithValidator(deployment)) {
            throw new InvalidDeploymentException(deployment);
        }
        return deployment;
    }

    @Workdir
    public String createTask(Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(deployment);
        if (!this.validateDeploymentWithValidator(deployment)) {
            throw new InvalidDeploymentException("The deployment has validation errors.");
        }
        logger.trace("Creating task for {}", (Object)deployment);
        try {
            TaskSpecification deploymentTask = this.createDeploymentTask(deployment);
            String taskId = this.engine.register(deploymentTask);
            logger.debug("Registered {} task {} for Deployed Application {}", new Object[]{deployment.getDeploymentType(), taskId, deployment.getDeployedApplication().getId()});
            EventBusHolder.publish((Object)new TaskCreatedEvent(taskId, deployment.getDeploymentType().toString(), deployment.getDeployedApplication().getId()));
            return taskId;
        }
        catch (RuntimeException e) {
            WorkdirHolder.get().delete();
            throw e;
        }
    }

    public String rollback(@PathParam(value="taskid") String taskid) {
        Task retrieve = this.engine.retrieve(taskid);
        TaskSpecification rollback = this.rollbackService.rollback(retrieve);
        return this.engine.register(rollback);
    }

    private void checkPermission(Deployment deployment) {
        String environment = ((DeployedApplication)deployment.getDeployedApplication()).getEnvironment().getId();
        switch (deployment.getDeploymentType()) {
            case INITIAL: {
                this.checkPermission(Permission.DEPLOY_INITIAL, environment);
                break;
            }
            case UPDATE: {
                this.checkPermission(Permission.DEPLOY_UPGRADE, environment);
                break;
            }
            case UNDEPLOYMENT: {
                this.checkPermission(Permission.UNDEPLOY, environment);
            }
        }
    }

    private TaskSpecification createDeploymentTask(Deployment deployment) {
        switch (deployment.getDeploymentType()) {
            case INITIAL: {
                return this.createInitialDeploymentTask(deployment);
            }
            case UPDATE: {
                return this.createUpdateTask(deployment);
            }
            case UNDEPLOYMENT: {
                return this.createUndeploymentTask(deployment);
            }
        }
        throw new IllegalArgumentException("Unknown deployment type: " + deployment.getDeploymentType());
    }

    private TaskSpecification createInitialDeploymentTask(Deployment deployment) {
        DeployedApplication deployedApp = (DeployedApplication)deployment.getDeployedApplication();
        deployedApp.addDeployeds(DeploymentResource.getDeployeds(deployment));
        DeltaSpecification deltaSpecification = this.deploymentService.prepareInitialDeployment(deployedApp);
        this.repositoryService.checkReferentialIntegrity(ChangeSetBuilder.determineChanges((DeltaSpecification)deltaSpecification));
        return this.deploymentService.getTaskSpecification(deltaSpecification, new WorkDir[]{WorkdirHolder.get()});
    }

    private TaskSpecification createUpdateTask(Deployment deployment) {
        DeployedApplication deployedApp = (DeployedApplication)deployment.getDeployedApplication();
        deployedApp.addDeployeds(DeploymentResource.getDeployeds(deployment));
        WorkDir workDirForExistingDeployment = this.workDirFactory.newWorkDir();
        try {
            DeployedApplication existingDeployedApplication = (DeployedApplication)this.repositoryService.read(deployment.getDeployedApplication().getId(), workDirForExistingDeployment);
            DeltaSpecification deltaSpecification = this.deploymentService.prepareUpgradeDeployment(deployedApp, existingDeployedApplication);
            this.repositoryService.checkReferentialIntegrity(ChangeSetBuilder.determineChanges((DeltaSpecification)deltaSpecification));
            return this.deploymentService.getTaskSpecification(deltaSpecification, new WorkDir[]{workDirForExistingDeployment, WorkdirHolder.get()});
        }
        catch (RuntimeException e) {
            workDirForExistingDeployment.delete();
            WorkdirHolder.get().delete();
            throw e;
        }
    }

    private TaskSpecification createUndeploymentTask(Deployment deployment) {
        DeployedApplication deployedApplication = (DeployedApplication)deployment.getDeployedApplication();
        this.checkPermission(Permission.UNDEPLOY, deployedApplication.getEnvironment().getId());
        DeltaSpecification deltaSpecification = this.deploymentService.prepareUndeployment(deployedApplication);
        this.repositoryService.checkReferentialIntegrity(ChangeSetBuilder.determineChanges((DeltaSpecification)deltaSpecification));
        return this.deploymentService.getTaskSpecification(deltaSpecification, new WorkDir[]{WorkdirHolder.get()});
    }

    private static Collection<Deployed> getDeployeds(Deployment deployment) {
        List deployedEntities = deployment.getDeployeds();
        return Collections2.transform((Collection)deployedEntities, (Function)new Function<ConfigurationItem, Deployed>(){

            public Deployed apply(ConfigurationItem input) {
                Checks.checkArgument((boolean)(input instanceof Deployed), (String)"%s should be a Deployed", (Object[])new Object[]{input.getId()});
                return (Deployed)input;
            }
        });
    }

    private boolean validateDeploymentWithValidator(Deployment deployment) {
        ConfigurationItem deployedApplicationEntity = deployment.getDeployedApplication();
        List messages = this.validator.validate(deployedApplicationEntity, Collections.EMPTY_LIST);
        Iterable filteredMessages = Iterables.filter((Iterable)messages, (Predicate)new Predicate<ValidationMessage>(){

            public boolean apply(ValidationMessage input) {
                return !input.getPropertyName().equals("deployeds");
            }
        });
        if (Iterables.size((Iterable)filteredMessages) > 0) {
            ValidatedConfigurationItem validatedConfigurationItem = new ValidatedConfigurationItem(deployment.getDeployedApplication());
            validatedConfigurationItem.setValidations((List)Lists.newArrayList((Iterable)filteredMessages));
            deployment.setDeployedApplication((ConfigurationItem)validatedConfigurationItem);
            return false;
        }
        return this.validateDeployedsWithValidator(deployment.getDeployeds());
    }

    private boolean validateDeployedsWithValidator(List<ConfigurationItem> deployeds) {
        boolean allValid = true;
        ArrayList toBeValidated = Lists.newArrayList(deployeds);
        deployeds.clear();
        for (ConfigurationItem validate : toBeValidated) {
            List messages = this.validator.validate(validate, (List)toBeValidated);
            if (!messages.isEmpty()) {
                ValidatedConfigurationItem vci = new ValidatedConfigurationItem(validate);
                vci.setValidations(messages);
                deployeds.add((ConfigurationItem)vci);
                allValid = false;
                continue;
            }
            deployeds.add(validate);
        }
        return allValid;
    }

    private static Deployment createDeployment(Version version, Environment env) {
        DeployedApplication deployedApplication = (DeployedApplication)DescriptorRegistry.getDescriptor((Type)Type.valueOf(DeployedApplication.class)).newInstance();
        deployedApplication.setVersion(version);
        deployedApplication.setEnvironment(env);
        IdGenerator.generateId((DeployedApplication)deployedApplication);
        return DeploymentResource.createDeployment(deployedApplication, Deployment.DeploymentType.INITIAL);
    }

    private static Deployment createDeployment(DeployedApplication deployedApplication, Deployment.DeploymentType type) {
        Deployment deployment = new Deployment();
        deployment.setDeploymentType(type);
        deployment.setDeployedApplication((ConfigurationItem)deployedApplication);
        deployment.setDeployables(DeploymentResource.sort(Lists.newArrayList((Iterable)Iterables.transform((Iterable)deployedApplication.getVersion().getDeployables(), DtoReader.ciToCiId))));
        deployment.setContainers(DeploymentResource.sort(Lists.newArrayList((Iterable)Iterables.transform((Iterable)deployedApplication.getEnvironment().getMembers(), DtoReader.ciToCiId))));
        return deployment;
    }

    private static List<ConfigurationItemId> sort(List<ConfigurationItemId> toBeSorted) {
        Collections.sort(toBeSorted, new Comparator<ConfigurationItemId>(){

            @Override
            public int compare(ConfigurationItemId o1, ConfigurationItemId o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return toBeSorted;
    }

    @HttpResponseCodeResult(statusCode=400)
    private class InvalidDeploymentException
    extends DeployitException {
        public InvalidDeploymentException(Deployment deployment) {
            super((Object)deployment);
        }

        public InvalidDeploymentException(String message) {
            super(message);
        }
    }
}

