/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.ContainerExtractor;
import org.apache.tika.extractor.EmbeddedResourceHandler;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParserContainerExtractor
implements ContainerExtractor {
    private static final long serialVersionUID = 2261131045580861514L;
    private final Parser parser;
    private final Detector detector;

    public ParserContainerExtractor() {
        this(TikaConfig.getDefaultConfig());
    }

    public ParserContainerExtractor(TikaConfig config) {
        this(new AutoDetectParser(config), config.getMimeRepository());
    }

    public ParserContainerExtractor(Parser parser, Detector detector) {
        this.parser = parser;
        this.detector = detector;
    }

    public boolean isSupported(TikaInputStream input) throws IOException {
        MediaType type = this.detector.detect(input, new Metadata());
        return this.parser.getSupportedTypes(new ParseContext()).contains(type);
    }

    public void extract(TikaInputStream stream, final ContainerExtractor recurseExtractor, final EmbeddedResourceHandler handler) throws IOException, TikaException {
        ParseContext context = new ParseContext();
        context.set(Parser.class, new Parser(){

            @Override
            public Set<MediaType> getSupportedTypes(ParseContext context) {
                return ParserContainerExtractor.this.parser.getSupportedTypes(context);
            }

            @Override
            public void parse(InputStream stream, ContentHandler ignored, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
                MediaType type;
                String filename = metadata.get("resourceName");
                if (metadata.get("Content-Type") != null) {
                    type = MediaType.parse(metadata.get("Content-Type"));
                } else {
                    if (!stream.markSupported()) {
                        stream = TikaInputStream.get(stream);
                    }
                    type = ParserContainerExtractor.this.detector.detect(stream, metadata);
                }
                handler.handle(filename, type, stream);
                if (recurseExtractor != null) {
                    if (recurseExtractor == ParserContainerExtractor.this) {
                        ParserContainerExtractor.this.parser.parse(stream, new DefaultHandler(), metadata, context);
                    } else {
                        recurseExtractor.extract(TikaInputStream.get(stream), recurseExtractor, handler);
                    }
                }
            }

            @Override
            public void parse(InputStream stream, ContentHandler handler2, Metadata metadata) throws IOException, SAXException, TikaException {
                this.parse(stream, handler2, metadata, new ParseContext());
            }
        });
        try {
            this.parser.parse(stream, new DefaultHandler(), new Metadata(), context);
        }
        catch (SAXException e) {
            throw new TikaException("Unexpected SAX exception", e);
        }
    }
}

