/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ObjectFactory;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.api.legacy.FullTaskInfos;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.DateHelp;
import com.xebialabs.deployit.cli.help.ExportHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.engine.api.dto.ArtifactAndData;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CliObject(name="repository")
@ClassHelp(description="Gateway to doing CRUD operations on all types of CIs")
public class RepositoryClient
extends DocumentedObject {
    public static final Function<ConfigurationItemId, String> ciIdToString = new Function<ConfigurationItemId, String>(){

        public String apply(ConfigurationItemId input) {
            return input.getId();
        }
    };
    private final ProxiesInstance proxies;
    private DeployitCommunicator communicator;
    private static final Logger logger = LoggerFactory.getLogger(RepositoryClient.class);

    public RepositoryClient() {
        this.proxies = null;
    }

    public RepositoryClient(ProxiesInstance proxies) {
        this.proxies = proxies;
        this.communicator = proxies.getCommunicator();
    }

    @MethodHelp(description="Create a new CI in the repository", parameters={@ParameterHelp(name="ci", description="The CI (ConfigurationItem) that should be created in the repository")})
    public ConfigurationItem create(ConfigurationItem object) {
        Preconditions.checkArgument((object.getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        ConfigurationItem created = this.proxies.getRepository().create(object.getId(), object);
        return RepositoryClient.checkForValidations(created);
    }

    @MethodHelp(description="Create a new artifact CI in the repository", parameters={@ParameterHelp(name="artifact", description="The Artifact that should be created in the repository")})
    public ConfigurationItem create(ArtifactAndData artifact) {
        Preconditions.checkArgument((artifact.getArtifact().getId() != null ? 1 : 0) != 0, (Object)"The artifact should have a set id.");
        ConfigurationItem configurationItem = this.proxies.getRepository().create(artifact.getArtifact().getId(), artifact);
        return RepositoryClient.checkForValidations(configurationItem);
    }

    @MethodHelp(description="Create all new CIs in the repository, commonly used after a discovery", parameters={@ParameterHelp(name="cis", description="The CIs (ConfigurationItems) that should be created in the repository")})
    public List<ConfigurationItem> create(List<ConfigurationItem> cis) {
        List response = this.proxies.getRepository().create(cis);
        return RepositoryClient.checkAllForValidations(response);
    }

    private static List<ConfigurationItem> checkAllForValidations(List<ConfigurationItem> cis) {
        for (ConfigurationItem ci : cis) {
            ValidatedConfigurationItem vci;
            if (!(ci instanceof ValidatedConfigurationItem) || (vci = (ValidatedConfigurationItem)ci).getValidations().isEmpty()) continue;
            logger.error("Configuration item contained validation errors: {}", (Object)vci.getValidations());
        }
        return cis;
    }

    @MethodHelp(description="Read a CI form the repository", parameters={@ParameterHelp(name="id", description="The id of the CI to read")})
    public ConfigurationItem read(String id) {
        return this.proxies.getRepository().read(id);
    }

    @MethodHelp(description="Update an existing CI in the repository", parameters={@ParameterHelp(name="ci", description="The updated CI (ConfigurationItem) that should be stored in the repository")})
    public ConfigurationItem update(ConfigurationItem object) {
        Preconditions.checkArgument((object.getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        return RepositoryClient.checkForValidations(this.proxies.getRepository().update(object.getId(), object));
    }

    @MethodHelp(description="Update an existing artifact in the repository", parameters={@ParameterHelp(name="artifact", description="The updated artifact CI that should be stored in the repository")})
    public ConfigurationItem update(ArtifactAndData artifact) {
        Preconditions.checkArgument((artifact.getArtifact().getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        return RepositoryClient.checkForValidations(this.proxies.getRepository().update(artifact.getArtifact().getId(), artifact));
    }

    @MethodHelp(description="Move a CI from one location to another", parameters={@ParameterHelp(name="ci", description="The CI that is to be moved"), @ParameterHelp(name="newId", description="The new id of the CI")}, returns="The CI with the new id")
    public ConfigurationItem move(ConfigurationItem ci, String newId) {
        return this.move(ci.getId(), newId);
    }

    @MethodHelp(description="Move a CI from one location to another", parameters={@ParameterHelp(name="id", description="The id of the CI that is to be moved"), @ParameterHelp(name="newId", description="The new id of the CI")}, returns="The CI with the new id")
    public ConfigurationItem move(String id, String newId) {
        return this.proxies.getRepository().move(id, newId);
    }

    @MethodHelp(description="Rename a CI", parameters={@ParameterHelp(name="ci", description="The CI to rename"), @ParameterHelp(name="newName", description="The new name (last part of the id)")}, returns="The CI with the updated name")
    public ConfigurationItem rename(ConfigurationItem ci, String newName) {
        return this.rename(ci.getId(), newName);
    }

    @MethodHelp(description="Rename a CI", parameters={@ParameterHelp(name="id", description="The id of the CI to rename"), @ParameterHelp(name="newName", description="The new name (last part of the id)")}, returns="The CI with the updated name")
    public ConfigurationItem rename(String id, String newName) {
        return this.proxies.getRepository().rename(id, newName);
    }

    @MethodHelp(description="Delete a CI with a specific id from the repository", parameters={@ParameterHelp(name="id", description="The id of the CI")})
    public void delete(String id) {
        this.proxies.getRepository().delete(id);
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository", parameters={@ParameterHelp(name="ciType", description="")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String ciType) {
        Type t = null;
        if (ciType != null) {
            if (!DescriptorRegistry.exists((Type)ObjectFactory.toType(ciType))) {
                System.err.println("Configuration item type [" + ciType + "] not known.");
                return null;
            }
            t = ObjectFactory.toType(ciType);
        }
        List ids = this.proxies.getRepository().query(t, null, null, null, null, 0L, -1L);
        return Lists.newArrayList((Iterable)Lists.transform((List)ids, ciIdToString));
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository which are located under the specified parent node.", parameters={@ParameterHelp(name="ciType", description="The type of configuration item to look for (eg. udm.DeployedApplication)"), @ParameterHelp(name="parent", description="The id of the parent node to search under (eg. Environments/env1)")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String ciType, String parent) {
        if (ciType != null && !DescriptorRegistry.exists((Type)ObjectFactory.toType(ciType))) {
            System.err.println("Configuration item type [" + ciType + "] not known.");
            return null;
        }
        List ids = this.proxies.getRepository().query(ObjectFactory.toType(ciType), parent, null, null, null, 0L, -1L);
        return Lists.newArrayList((Iterable)Lists.transform((List)ids, ciIdToString));
    }

    @MethodHelp(description="Search for CIs with a (partial) name in the repository.", parameters={@ParameterHelp(name="name", description="The name of the configuration item to search for. Can contain '%' as wildcard")}, returns="The ids of the configuration items that match the name.")
    public List<String> searchByName(String name) {
        if (name == null) {
            System.err.println("No name specified to search for.");
            return null;
        }
        List ids = this.proxies.getRepository().query(null, null, name, null, null, 0L, -1L);
        return Lists.newArrayList((Iterable)Lists.transform((List)ids, ciIdToString));
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository were created before the given date.", parameters={@ParameterHelp(name="ciType", description="The type of configuration item to look for (eg. udm.DeployedApplication)"), @ParameterHelp(name="before", description="a java.util.Calendar which specifies a moment in time before which the CI has to be created")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String ciType, Calendar c) {
        List ids = this.proxies.getRepository().query(ObjectFactory.toType(ciType), null, null, new DateTime((Object)c), null, 0L, -1L);
        return Lists.newArrayList((Iterable)Lists.transform((List)ids, ciIdToString));
    }

    @MethodHelp(description="Read multiple objects from the repostory in one go.", parameters={@ParameterHelp(name="ids", description="The ids of the objects to read")})
    public List<ConfigurationItem> read(List<String> ids) {
        List objs = this.proxies.getRepository().read(ids);
        return objs;
    }

    @MethodHelp(description="Get all task information, including steps, from the repository's archive.", returns="This object contains all archived tasks with their enclosed steps")
    public FullTaskInfos getArchivedTasks() {
        return new FullTaskInfos(this.proxies.getTaskRegistry().export(null, null));
    }

    @MethodHelp(description="Get all task information, including steps, from the repository's archive in the specified date range.", parameters={@ParameterHelp(name="beginDate", description="Begin date from which to return tasks in 'MM/dd/yyyy' format"), @ParameterHelp(name="endDate", description="End date from which to return tasks in 'MM/dd/yyyy' format")}, returns="This object contains all archived tasks with their enclosed steps")
    public FullTaskInfos getArchivedTasks(String beginDate, String endDate) {
        return new FullTaskInfos(this.proxies.getTaskRegistry().export(DateHelp.toLocalDate(beginDate), DateHelp.toLocalDate(endDate)));
    }

    @MethodHelp(description="Export all task information, including steps, from the repository's archive to a local XML file", parameters={@ParameterHelp(name="filePath", description="Fully qualified pathname, including the file name, as to where to store the file to. Example: '/tmp/exportedTasks.xml'")})
    public void exportArchivedTasks(String filePath) throws IOException {
        this.getResourceToWrite(filePath, "/task/export");
    }

    @MethodHelp(description="Export all task information, including steps, from the repository's archive in the specified date range to a local XML file", parameters={@ParameterHelp(name="filePath", description="Fully qualified pathname, including the file name, as to where to store the file to. Example: '/tmp/exportedTasks.xml'"), @ParameterHelp(name="beginDate", description="Begin date from which to return tasks in 'MM/dd/yyyy' format"), @ParameterHelp(name="endDate", description="End date from which to return tasks in 'MM/dd/yyyy' format")})
    public void exportArchivedTasks(String filePath, String beginDate, String endDate) throws IOException {
        this.getResourceToWrite(filePath, String.format("/task/export?begindate=%s&enddate=%s", DateHelp.urlEncode(DateHelp.transform(beginDate, "MM/dd/yyyy", "yyyy-MM-dd")), DateHelp.urlEncode(DateHelp.transform(endDate, "MM/dd/yyyy", "yyyy-MM-dd"))));
    }

    @MethodHelp(description="Export a deployment package in DAR format to a local file", parameters={@ParameterHelp(name="directoryPath", description="Fully qualified path of the directory where the deployment package will be exported with name '<application-name>-<version>.dar'. Directory will be created if it doesn't exist"), @ParameterHelp(name="versionId", description="Id of the deployment package that needs to be exported")})
    public void exportDar(String directoryPath, String versionId) throws IOException {
        File directory;
        ConfigurationItem ci = this.read(versionId);
        if (!ci.getType().equals((Object)Type.valueOf((String)"udm", (String)"DeploymentPackage"))) {
            System.err.println("Export expected Id corresponding to type udm.DeploymentPackage but was actually of type " + ci.getType());
        }
        if (!(directory = new File(directoryPath)).exists()) {
            directory.mkdirs();
        }
        String version = ci.getId().substring(ci.getId().lastIndexOf("/") + 1);
        String idWithoutVersion = ci.getId().substring(0, ci.getId().lastIndexOf("/"));
        String appName = idWithoutVersion.substring(idWithoutVersion.lastIndexOf("/") + 1);
        String filePath = directoryPath + File.separator + appName + "-" + version + ".dar";
        String s = this.proxies.getExportProxy().exportDar(ci.getId());
        this.getResourceToWrite(filePath, "/internal/download/" + s);
    }

    @MethodHelp(description="Check for existence of an id, does not guarantee read access to said configuration item.", parameters={@ParameterHelp(name="id", description="The id of the configuration item")}, returns="true if there is a configuration item with that id.")
    public boolean exists(String id) {
        return this.proxies.getRepository().exists(id);
    }

    private static ConfigurationItem checkForValidations(ConfigurationItem ci) {
        if (ci instanceof ValidatedConfigurationItem && !((ValidatedConfigurationItem)ci).getValidations().isEmpty()) {
            logger.error("Configuration item contained validation errors: {}", (Object)((ValidatedConfigurationItem)ci).getValidations());
        }
        return ci;
    }

    private void getResourceToWrite(String filePath, String resourcePath) throws IOException {
        if (new ExportHelp(this.communicator).writeResourceToLocalFile(filePath, this.communicator.getConfig().getContext() + resourcePath) > 0L) {
            System.out.println(String.format("finished writing file to %s", filePath));
        } else {
            System.out.println("File was created but no bytes were written to the file.\n");
            System.out.println("Maybe the requested resource was not available or zero size!?");
        }
    }
}

