/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PrintHelper {
    private final Set<String> repositoryObjectParentIds = Sets.newHashSet();

    private PrintHelper() {
    }

    public static final PrintHelper getInstance() {
        return new PrintHelper();
    }

    public void printCi(ConfigurationItem object, RepositoryService repository) {
        this.printTopLevelCiWithIndent(object, "", repository);
    }

    public void printCis(Collection<ConfigurationItem> cis, RepositoryService repository) {
        this.repositoryObjectParentIds.addAll(Collections2.transform(cis, (Function)new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem input) {
                return input.getId();
            }
        }));
        for (ConfigurationItem ci : cis) {
            this.printTopLevelCiWithIndent(ci, "", repository);
        }
    }

    private void printTopLevelCiWithIndent(ConfigurationItem object, String indent, RepositoryService repository) {
        System.out.println(object.getType());
        this.printCiProperties(object, indent, repository);
    }

    private void printCiProperties(ConfigurationItem object, String indent, RepositoryService repository) {
        this.repositoryObjectParentIds.add(object.getId());
        PrintHelper.println(indent, "id", object.getId(), false);
        PrintHelper.println(indent, "values", null, true);
        this.printValues(object, indent + "    ", repository);
    }

    private void printValues(ConfigurationItem object, String indent, RepositoryService repository) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)object.getType());
        Iterator iterator = descriptor.getPropertyDescriptors().iterator();
        block7: while (iterator.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)iterator.next();
            Object value = pd.get(object);
            if (value == null) continue;
            boolean last = !iterator.hasNext();
            String deepIndent = indent + (iterator.hasNext() ? "|   " : "    ");
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    PrintHelper.println(indent, pd, value.toString(), last);
                    break;
                }
                case SET_OF_STRING: 
                case LIST_OF_STRING: {
                    PrintHelper.println(indent, pd, null, last);
                    Collection strings = (Collection)value;
                    Iterator stringIt = strings.iterator();
                    while (stringIt.hasNext()) {
                        String string = (String)stringIt.next();
                        PrintHelper.println(deepIndent, string, null, !stringIt.hasNext());
                    }
                    continue block7;
                }
                case MAP_STRING_STRING: {
                    PrintHelper.println(indent, pd, null, last);
                    Map stringMap = (Map)value;
                    for (Map.Entry mapEntry : stringMap.entrySet()) {
                        PrintHelper.println(deepIndent, (String)mapEntry.getKey(), (String)mapEntry.getValue(), !iterator.hasNext());
                    }
                    continue block7;
                }
                case CI: {
                    String id = (String)value;
                    if (!this.repositoryObjectParentIds.contains(id)) {
                        ConfigurationItem nested = repository.read(id);
                        PrintHelper.println(indent, pd, nested.getType().toString(), last);
                        this.printCiProperties(nested, deepIndent, repository);
                        break;
                    }
                    PrintHelper.println(indent, pd, "REFERENCE => " + id, last);
                    break;
                }
                case SET_OF_CI: 
                case LIST_OF_CI: {
                    PrintHelper.println(indent, pd, null, last);
                    Collection ids = (Collection)value;
                    this.printSetOfCis(deepIndent, ids, repository);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown PropertyKind: " + pd.getKind() + " for " + pd.getFqn());
                }
            }
        }
    }

    private void printSetOfCis(String indent, Collection<String> ids, RepositoryService repository) {
        Iterator<String> idIt = ids.iterator();
        while (idIt.hasNext()) {
            String nestedid = idIt.next();
            if (!this.repositoryObjectParentIds.contains(nestedid)) {
                ConfigurationItem nestedCi = repository.read(nestedid);
                PrintHelper.println(indent, nestedCi.getType().toString(), null, !idIt.hasNext());
                this.printCiProperties(nestedCi, indent + (idIt.hasNext() ? "|   " : "    "), repository);
                continue;
            }
            PrintHelper.println(indent, "REFERENCE => " + nestedid, null, !idIt.hasNext());
        }
    }

    private static String getIndicator(PropertyDescriptor pd) {
        if (pd.isHidden()) {
            return " (hidden)";
        }
        return "";
    }

    private static void println(String indent, String key, String value, boolean last) {
        System.out.println(indent + (last ? "\\-- " : "+-- ") + key + (value != null ? ": " + value : ""));
    }

    private static void println(String indent, PropertyDescriptor pd, String value, boolean last) {
        System.out.println(indent + (last ? "\\-- " : "+-- ") + pd.getName() + (value != null ? ": " + value : "") + PrintHelper.getIndicator(pd));
    }
}

