/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm.connector;

import com.google.common.io.Closeables;
import com.xebialabs.overthere.cifs.WinrmHttpsCertificateTrustStrategy;
import com.xebialabs.overthere.cifs.WinrmHttpsHostnameVerificationStrategy;
import com.xebialabs.overthere.cifs.winrm.HttpConnector;
import com.xebialabs.overthere.cifs.winrm.connector.KerberosJaasConfiguration;
import com.xebialabs.overthere.cifs.winrm.connector.ProvidedAuthCallback;
import com.xebialabs.overthere.cifs.winrm.connector.WsmanKerberosSchemeFactory;
import com.xebialabs.overthere.cifs.winrm.connector.WsmanSPNegoSchemeFactory;
import com.xebialabs.overthere.cifs.winrm.exception.BlankValueRuntimeException;
import com.xebialabs.overthere.cifs.winrm.exception.InvalidFilePathRuntimeException;
import com.xebialabs.overthere.cifs.winrm.exception.WinRMRuntimeIOException;
import com.xebialabs.overthere.cifs.winrm.soap.SoapAction;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.auth.Credentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpComponentsHttpClientHttpConnector
implements HttpConnector {
    private static Logger logger = LoggerFactory.getLogger(ApacheHttpComponentsHttpClientHttpConnector.class);
    private final String username;
    private final boolean enableKerberos;
    private final String password;
    private final URL targetURL;
    private WinrmHttpsCertificateTrustStrategy httpsCertTrustStrategy;
    private WinrmHttpsHostnameVerificationStrategy httpsHostnameVerifyStrategy;
    private boolean kerberosUseHttpSpn;
    private boolean kerberosAddPortToSpn;
    private boolean kerberosDebug;

    public ApacheHttpComponentsHttpClientHttpConnector(String username, String password, URL targetURL) {
        this.username = username;
        this.enableKerberos = username.contains("@");
        this.password = password;
        this.targetURL = targetURL;
    }

    @Override
    public Document sendMessage(Document requestDocument, SoapAction soapAction) {
        if (this.enableKerberos) {
            return this.runPrivileged(new PrivilegedSendMessage(requestDocument, soapAction));
        }
        return this.doSendMessage(requestDocument, soapAction);
    }

    private Document runPrivileged(PrivilegedSendMessage privilegedSendMessage) {
        Document result;
        ProvidedAuthCallback handler = new ProvidedAuthCallback(this.username, this.password);
        try {
            LoginContext lc = new LoginContext("", null, handler, new KerberosJaasConfiguration(this.kerberosDebug));
            lc.login();
            result = Subject.doAs(lc.getSubject(), privilegedSendMessage);
        }
        catch (LoginException e) {
            throw new WinRMRuntimeIOException("Login failure sending message on " + this.getTargetURL() + " error: " + e.getMessage(), privilegedSendMessage.getRequestDocument(), null, e);
        }
        catch (PrivilegedActionException e) {
            throw new WinRMRuntimeIOException("Failure sending message on " + this.getTargetURL() + " error: " + e.getMessage(), privilegedSendMessage.getRequestDocument(), null, e.getException());
        }
        return result;
    }

    private Document doSendMessage(Document requestDocument, SoapAction soapAction) {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            this.configureHttpClient(client);
            BasicHttpContext context = new BasicHttpContext();
            HttpPost request = new HttpPost(this.getTargetURL().toURI());
            if (soapAction != null) {
                request.setHeader("SOAPAction", soapAction.getValue());
            }
            String requestDocAsString = ApacheHttpComponentsHttpClientHttpConnector.toString(requestDocument);
            logger.trace("Sending request to {}", (Object)this.getTargetURL());
            logger.trace("Request body: {} {}", (Object)this.getTargetURL(), (Object)requestDocAsString);
            HttpEntity entity = this.createEntity(requestDocAsString);
            request.setEntity(entity);
            HttpResponse response = client.execute((HttpUriRequest)request, (HttpContext)context);
            if (logger.isTraceEnabled()) {
                for (Header header : response.getAllHeaders()) {
                    logger.trace("Header {}: {}", (Object)header.getName(), (Object)header.getValue());
                }
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new WinRMRuntimeIOException("Response code was " + response.getStatusLine().getStatusCode());
            }
            String text = this.handleResponse(response, (HttpContext)context);
            EntityUtils.consume((HttpEntity)response.getEntity());
            logger.trace("Response body: {}", (Object)text);
            Document document = DocumentHelper.parseText((String)text);
            return document;
        }
        catch (BlankValueRuntimeException exc) {
            throw exc;
        }
        catch (InvalidFilePathRuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new WinRMRuntimeIOException("Send message on " + this.getTargetURL() + " error ", requestDocument, null, exc);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void configureHttpClient(DefaultHttpClient httpclient) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this.configureTrust(httpclient);
        this.configureAuthentication(httpclient, "Basic", (Principal)new BasicUserPrincipal(this.username));
        if (this.enableKerberos) {
            if (this.kerberosUseHttpSpn) {
                httpclient.getAuthSchemes().register("Kerberos", (AuthSchemeFactory)new KerberosSchemeFactory(!this.kerberosAddPortToSpn));
                httpclient.getAuthSchemes().register("negotiate", (AuthSchemeFactory)new SPNegoSchemeFactory(!this.kerberosAddPortToSpn));
            } else {
                httpclient.getAuthSchemes().register("Kerberos", (AuthSchemeFactory)new WsmanKerberosSchemeFactory(!this.kerberosAddPortToSpn));
                httpclient.getAuthSchemes().register("negotiate", (AuthSchemeFactory)new WsmanSPNegoSchemeFactory(!this.kerberosAddPortToSpn));
            }
            this.configureAuthentication(httpclient, "Kerberos", new KerberosPrincipal(this.username));
            this.configureAuthentication(httpclient, "negotiate", new KerberosPrincipal(this.username));
        }
        httpclient.getParams().setBooleanParameter("http.protocol.handle-authentication", true);
    }

    protected void configureAuthentication(DefaultHttpClient httpclient, String scheme, final Principal principal) {
        httpclient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, scheme), new Credentials(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public String getPassword() {
                return ApacheHttpComponentsHttpClientHttpConnector.this.password;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleResponse(HttpResponse response, HttpContext context) throws IOException {
        HttpEntity entity = response.getEntity();
        if (null == entity.getContentType() || !entity.getContentType().getValue().startsWith("application/soap+xml")) {
            throw new WinRMRuntimeIOException("Send message on " + this.getTargetURL() + " error: Unexpected content-type: " + entity.getContentType());
        }
        InputStream is = entity.getContent();
        StringWriter writer = new StringWriter();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        try {
            int n;
            char[] buffer = new char[1024];
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)reader);
            Closeables.closeQuietly((Closeable)is);
        }
        return ((Object)writer).toString();
    }

    private void configureTrust(DefaultHttpClient httpclient) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        if (!"https".equalsIgnoreCase(this.getTargetURL().getProtocol())) {
            return;
        }
        TrustStrategy trustStrategy = this.httpsCertTrustStrategy.getStrategy();
        X509HostnameVerifier hostnameVerifier = this.httpsHostnameVerifyStrategy.getVerifier();
        SSLSocketFactory socketFactory = new SSLSocketFactory(trustStrategy, hostnameVerifier);
        Scheme sch = new Scheme("https", 443, (SchemeSocketFactory)socketFactory);
        httpclient.getConnectionManager().getSchemeRegistry().register(sch);
    }

    protected static String toString(Document doc) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
        try {
            xmlWriter.write(doc);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new WinRMRuntimeIOException("Cannnot convert XML to String ", e);
        }
        return stringWriter.toString();
    }

    protected HttpEntity createEntity(String requestDocAsString) throws UnsupportedEncodingException {
        return new StringEntity(requestDocAsString, ContentType.create((String)"application/soap+xml", (String)"UTF-8"));
    }

    public URL getTargetURL() {
        return this.targetURL;
    }

    public void setHttpsCertTrustStrategy(WinrmHttpsCertificateTrustStrategy httpsCertTrustStrategy) {
        this.httpsCertTrustStrategy = httpsCertTrustStrategy;
    }

    public void setHttpsHostnameVerifyStrategy(WinrmHttpsHostnameVerificationStrategy httpsHostnameVerifyStrategy) {
        this.httpsHostnameVerifyStrategy = httpsHostnameVerifyStrategy;
    }

    public void setKerberosUseHttpSpn(boolean kerberosUseHttpSpn) {
        this.kerberosUseHttpSpn = kerberosUseHttpSpn;
    }

    public void setKerberosAddPortToSpn(boolean kerberosAddPortToSpn) {
        this.kerberosAddPortToSpn = kerberosAddPortToSpn;
    }

    public void setKerberosDebug(boolean kerberosDebug) {
        this.kerberosDebug = kerberosDebug;
    }

    private class PrivilegedSendMessage
    implements PrivilegedExceptionAction<Document> {
        private Document requestDocument;
        private SoapAction soapAction;

        private PrivilegedSendMessage(Document requestDocument, SoapAction soapAction) {
            this.requestDocument = requestDocument;
            this.soapAction = soapAction;
        }

        @Override
        public Document run() throws Exception {
            return ApacheHttpComponentsHttpClientHttpConnector.this.doSendMessage(this.requestDocument, this.soapAction);
        }

        public Document getRequestDocument() {
            return this.requestDocument;
        }
    }
}

