/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.ClosingExceptionMapper;
import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.Sanitizer;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.xml.XStreamReaderWriter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class DeployitExceptionMapper
extends ClosingExceptionMapper<DeployitException>
implements ExceptionMapper<DeployitException> {
    private static final Logger logger = LoggerFactory.getLogger(DeployitExceptionMapper.class);

    @Override
    public Response handleException(DeployitException exception) {
        logger.info("Intercepting DeployitException", (Throwable)exception);
        HttpResponseCodeResult annotation = exception.getClass().getAnnotation(HttpResponseCodeResult.class);
        int status = 500;
        if (annotation != null) {
            status = annotation.statusCode();
        }
        Response.ResponseBuilder response = Response.status((int)status).type("application/xml");
        response.header("X-Deployit-Exception", (Object)"true");
        response.header("X-Exception-Type", (Object)exception.getClass().getName());
        response.header("X-Path", PathInterceptor.PATH.get());
        if (exception.hasEntity()) {
            response.header("X-Entity", (Object)"true");
            response.entity((Object)XStreamReaderWriter.getConfiguredXStream().toXML(exception.getEntity()));
        } else {
            response.entity((Object)Sanitizer.sanitize(Exceptions.getAllMessages((Exception)exception))).build();
        }
        return response.build();
    }
}

