/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptedSimpleCredentials
implements Credentials {
    private static final Logger log = LoggerFactory.getLogger(CryptedSimpleCredentials.class);
    private final String algorithm;
    private final String cryptedPassword;
    private final String userId;
    private final Map<String, Object> attributes;

    public CryptedSimpleCredentials(SimpleCredentials credentials) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this.userId = credentials.getUserID();
        if (this.userId == null || this.userId.length() == 0) {
            throw new IllegalArgumentException();
        }
        char[] pwd = credentials.getPassword();
        if (pwd == null) {
            throw new IllegalArgumentException();
        }
        String password = new String(pwd);
        this.algorithm = "sha1";
        this.cryptedPassword = CryptedSimpleCredentials.crypt(password, this.algorithm);
        String[] attNames = credentials.getAttributeNames();
        this.attributes = new HashMap<String, Object>(attNames.length);
        for (String attName : attNames) {
            this.attributes.put(attName, credentials.getAttribute(attName));
        }
    }

    public CryptedSimpleCredentials(String userId, String cryptedPassword) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("Invalid userID: The userID must have a length > 0.");
        }
        if (cryptedPassword == null) {
            throw new IllegalArgumentException("Password may not be null.");
        }
        this.userId = userId;
        String algo = CryptedSimpleCredentials.extractAlgorithm(cryptedPassword);
        if (algo == null) {
            log.debug("Plain text password -> Using sha1 to create digest.");
            this.algorithm = "sha1";
            this.cryptedPassword = CryptedSimpleCredentials.crypt(cryptedPassword, this.algorithm);
        } else {
            this.algorithm = algo;
            this.cryptedPassword = cryptedPassword;
        }
        this.attributes = Collections.emptyMap();
    }

    public String getUserID() {
        return this.userId;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getPassword() {
        return this.cryptedPassword;
    }

    public boolean matches(SimpleCredentials credentials) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.getUserID().equalsIgnoreCase(credentials.getUserID())) {
            return this.cryptedPassword.equals(CryptedSimpleCredentials.crypt(String.valueOf(credentials.getPassword()), this.algorithm));
        }
        return false;
    }

    private static String crypt(String pwd, String algorithm) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuilder password = new StringBuilder();
        password.append("{").append(algorithm).append("}");
        password.append(Text.digest((String)algorithm, (byte[])pwd.getBytes("UTF-8")));
        return password.toString();
    }

    private static String extractAlgorithm(String cryptedPwd) {
        int end = cryptedPwd.indexOf("}");
        if (cryptedPwd.startsWith("{") && end > 0) {
            String algorithm = cryptedPwd.substring(1, end);
            try {
                MessageDigest.getInstance(algorithm);
                return algorithm;
            }
            catch (NoSuchAlgorithmException e) {
                log.debug("Invalid algorithm detected " + algorithm);
            }
        }
        return null;
    }
}

