/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.ScriptEngineBuilder;
import com.xebialabs.deployit.cli.help.HelpScanner;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jline.console.ConsoleReader;
import org.python.core.PyException;

public class Interpreter {
    private ScriptEngine scriptEngine;
    private CliOptions options;
    private ScriptContext scriptContext;
    private ConsoleReader consoleReader;
    private DeployitCommunicator communicator;

    public Interpreter(ConsoleReader consoleReader, ScriptEngineBuilder scriptEngineBuilder, DeployitCommunicator communicator, CliOptions options) {
        this.consoleReader = consoleReader;
        this.communicator = communicator;
        this.scriptEngine = scriptEngineBuilder.build(options);
        this.options = options;
        this.scriptContext = new SimpleScriptContext();
        ScriptContext context = this.scriptEngine.getContext();
        this.scriptContext.setBindings(context.getBindings(100), 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interpret() throws Exception {
        block9: {
            try {
                if (this.options.interpretSourceFile()) {
                    this.scriptContext.setAttribute("javax.script.filename", this.options.getSourceFileName(), 100);
                    FileReader reader = new FileReader(this.options.getSourceFileName());
                    try {
                        this.evaluate(reader);
                        break block9;
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)reader);
                    }
                }
                try {
                    this.advancedRepl(this.consoleReader);
                }
                catch (Exception e) {
                    throw new IllegalStateException("The REPL gave an exception!", e);
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + this.options.getSourceFileName() + " could not be read, reason:" + e.getMessage());
                System.exit(1);
            }
            catch (ScriptException e) {
                System.err.println("An error occurred while interpreting file " + this.options.getSourceFileName() + ", reason:" + e.getMessage());
                System.exit(1);
            }
        }
    }

    public Object evaluate(Reader reader) throws ScriptException {
        return this.scriptEngine.eval(reader, this.scriptContext);
    }

    Object evaluate(String expression) throws ScriptException {
        if (expression == null) {
            return null;
        }
        return this.scriptEngine.eval(expression, this.scriptContext);
    }

    private void advancedRepl(ConsoleReader consoleReader) throws Exception {
        while (true) {
            String line;
            String trimmed;
            String string = trimmed = (line = consoleReader.readLine(this.getPrompt())) != null ? line.trim() : null;
            if (trimmed == null || trimmed.startsWith("quit") || trimmed.startsWith("exit")) break;
            if (trimmed.startsWith("help")) {
                HelpScanner.printHelp();
                continue;
            }
            try {
                Object evaluationResult = this.evaluate(line);
                if (evaluationResult instanceof String) {
                    System.out.println((String)evaluationResult);
                    continue;
                }
                if (evaluationResult == null) continue;
                System.out.println(evaluationResult.getClass().getSimpleName() + ": " + evaluationResult);
            }
            catch (ScriptException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    System.err.println(e.getMessage());
                    continue;
                }
                if (cause instanceof PyException) {
                    if (cause.getCause() == null) {
                        System.err.println(cause);
                        continue;
                    }
                    System.err.println(cause.getCause().getMessage());
                    continue;
                }
                System.err.println(cause);
            }
        }
        this.exit();
    }

    protected void exit() throws Exception {
        System.out.println("Bye bye!");
    }

    String getPrompt() {
        String prompt = "deployit > ";
        String username = this.communicator.getHttpClientHolder().getUserName();
        if (username != null) {
            prompt = username + " > ";
        }
        return prompt;
    }
}

