/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.ClosingExceptionMapper;
import com.xebialabs.deployit.DeployitExceptionMapper;
import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.Sanitizer;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class UnhandledExceptionMapper
extends ClosingExceptionMapper<RuntimeException>
implements ExceptionMapper<RuntimeException> {
    private static final Logger logger = LoggerFactory.getLogger(UnhandledExceptionMapper.class);

    @Override
    protected Response handleException(RuntimeException exception) {
        logger.debug("Intercepting (possibly) unhandled exception...");
        if (exception instanceof DeployitException) {
            return new DeployitExceptionMapper().toResponse((DeployitException)exception);
        }
        logger.error("Unhandled Exception: {}", (Throwable)exception);
        Response.ResponseBuilder builder = Response.serverError().type("application/xml");
        builder.header("X-Unhandled-Exception", (Object)"true");
        builder.header("X-Exception-Type", (Object)exception.getClass().getName());
        builder.header("X-Path", PathInterceptor.PATH.get());
        builder.entity((Object)Sanitizer.sanitize(Exceptions.getAllMessages(exception)));
        return builder.build();
    }
}

