/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.detect.ZipContainerDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

abstract class AbstractPOIFSExtractor {
    private final EmbeddedDocumentExtractor extractor;

    protected AbstractPOIFSExtractor(ParseContext context) {
        this.extractor = new EmbeddedDocumentExtractor(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        try {
            Metadata metadata = new Metadata();
            if (filename != null) {
                metadata.set("tika.mime.file", filename);
                metadata.set("resourceName", filename);
            }
            if (mediaType != null) {
                metadata.set("Content-Type", mediaType);
            }
            if (this.extractor.shouldParseEmbedded(metadata)) {
                this.extractor.parseEmbedded((InputStream)resource, (ContentHandler)xhtml, metadata, outputHtml);
            }
        }
        finally {
            resource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbededOfficeDoc(DirectoryEntry dir, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        try {
            Entry ooxml = dir.getEntry("Package");
            TikaInputStream ooxmlStream = TikaInputStream.get((InputStream)new DocumentInputStream((DocumentEntry)ooxml));
            ZipContainerDetector detector = new ZipContainerDetector();
            MediaType type = detector.detect(ooxmlStream, new Metadata());
            this.handleEmbeddedResource(ooxmlStream, null, type.toString(), xhtml, true);
            return;
        }
        catch (FileNotFoundException e) {
            POIFSFileSystem newFS = new POIFSFileSystem();
            this.copy(dir, (DirectoryEntry)newFS.getRoot());
            File tmpFile = File.createTempFile("tika", ".ole2");
            try {
                FileOutputStream out = new FileOutputStream(tmpFile);
                newFS.writeFilesystem((OutputStream)out);
                out.close();
                Metadata metadata = new Metadata();
                OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(dir);
                metadata.set("Content-Type", type.getType().toString());
                TikaInputStream embedded = TikaInputStream.get((File)tmpFile);
                try {
                    if (this.extractor.shouldParseEmbedded(metadata)) {
                        this.extractor.parseEmbedded((InputStream)embedded, (ContentHandler)xhtml, metadata, true);
                    }
                }
                finally {
                    embedded.close();
                }
            }
            finally {
                tmpFile.delete();
            }
            return;
        }
    }

    protected void copy(DirectoryEntry sourceDir, DirectoryEntry destDir) throws IOException {
        for (Entry entry : sourceDir) {
            if (entry instanceof DirectoryEntry) {
                DirectoryEntry newDir = destDir.createDirectory(entry.getName());
                this.copy((DirectoryEntry)entry, newDir);
                continue;
            }
            DocumentInputStream contents = new DocumentInputStream((DocumentEntry)entry);
            destDir.createDocument(entry.getName(), (InputStream)contents);
        }
    }
}

