/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.Set;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeInitializer {
    private static final Logger logger = LoggerFactory.getLogger(TypeInitializer.class);

    TypeInitializer() {
    }

    public static void init() {
        TypeInitializer.scanClasses();
    }

    static void scanClasses() {
        Set cis = Scannit.getInstance().getSubTypesOf(ConfigurationItem.class);
        for (Class ci : cis) {
            LocalDescriptorRegistry.register(ci);
        }
    }

    static void verifyTypes(Verifications verifications) {
        for (Descriptor descriptor : FluentIterable.from((Iterable)DescriptorRegistry.getDescriptors()).filter((Predicate)new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return !input.isVirtual();
            }
        })) {
            ((LocalDescriptor)descriptor).verify(verifications);
        }
    }
}

