/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.SafeKeyManager;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class PromptingKeyManager<K extends SafeKey<K>>
extends SafeKeyManager<K, PromptingKeyProvider<K>> {
    private final PromptingKeyProvider.View<K> view;

    public PromptingKeyManager(PromptingKeyProvider.View<K> view) {
        if (null == view) {
            throw new NullPointerException();
        }
        this.view = view;
    }

    final PromptingKeyProvider.View<K> getView() {
        return this.view;
    }

    @Override
    protected PromptingKeyProvider<K> newKeyProvider() {
        return new PromptingKeyProvider(this);
    }

    @Override
    public synchronized PromptingKeyProvider<K> getKeyProvider(URI resource) {
        PromptingKeyProvider provider = (PromptingKeyProvider)super.getKeyProvider(resource);
        provider.setResource(resource);
        return provider;
    }

    @Override
    @Nullable
    public synchronized PromptingKeyProvider<K> getMappedKeyProvider(URI resource) {
        PromptingKeyProvider provider = (PromptingKeyProvider)super.getMappedKeyProvider(resource);
        if (null != provider) {
            provider.setResource(resource);
        }
        return provider;
    }

    @Override
    public synchronized PromptingKeyProvider<K> moveKeyProvider(URI oldResource, URI newResource) {
        PromptingKeyProvider newProvider;
        PromptingKeyProvider oldProvider = (PromptingKeyProvider)super.moveKeyProvider(oldResource, newResource);
        if (null != oldProvider) {
            oldProvider.setResource(null);
        }
        if (null != (newProvider = (PromptingKeyProvider)super.getMappedKeyProvider(newResource))) {
            newProvider.setResource(newResource);
        }
        return oldProvider;
    }

    @Override
    public synchronized PromptingKeyProvider<K> removeKeyProvider(URI resource) {
        PromptingKeyProvider provider = (PromptingKeyProvider)super.removeKeyProvider(resource);
        if (null != provider) {
            provider.setResource(null);
        }
        return provider;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[view=" + this.getView() + ']';
    }
}

