/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WriteOutContentHandler
extends DefaultHandler {
    private final Writer writer;
    private final int writeLimit;
    private int writeCount = 0;

    private WriteOutContentHandler(Writer writer, int writeLimit) {
        this.writer = writer;
        this.writeLimit = writeLimit;
    }

    public WriteOutContentHandler(Writer writer) {
        this(writer, -1);
    }

    public WriteOutContentHandler(OutputStream stream) {
        this(new OutputStreamWriter(stream));
    }

    public WriteOutContentHandler(int writeLimit) {
        this(new StringWriter(), writeLimit);
    }

    public WriteOutContentHandler() {
        this(100000);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        block3: {
            try {
                if (this.writeLimit == -1 || this.writeCount + length <= this.writeLimit) {
                    this.writer.write(ch, start, length);
                    this.writeCount += length;
                    break block3;
                }
                this.writer.write(ch, start, this.writeLimit - this.writeCount);
                this.writeCount = this.writeLimit;
                throw new WriteLimitReachedException();
            }
            catch (IOException e) {
                throw new SAXException("Error writing out character content", e);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new SAXException("Error flushing character output", e);
        }
    }

    public String toString() {
        return this.writer.toString();
    }

    public boolean isWriteLimitReached(Throwable t) {
        if (t instanceof WriteLimitReachedException) {
            return this == ((WriteLimitReachedException)t).getSource();
        }
        return t.getCause() != null && this.isWriteLimitReached(t.getCause());
    }

    private class WriteLimitReachedException
    extends SAXException {
        private WriteLimitReachedException() {
        }

        public WriteOutContentHandler getSource() {
            return WriteOutContentHandler.this;
        }
    }
}

