/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;

public class ManifestEntry {
    private final String name;
    private final Attributes attributes;

    public ManifestEntry(String name, Attributes attributes) {
        this.name = name.trim();
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public String getValue(String name) {
        return this.attributes.getValue(name);
    }

    public Map<String, String> getMap(String name) {
        String keyStart = ("CI-" + name + "-").toLowerCase();
        HashMap map = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
            String s = entry.getKey().toString();
            if (!s.toLowerCase().startsWith(keyStart)) continue;
            String mapKey = s.substring(keyStart.length());
            String mapValue = (String)entry.getValue();
            map.put(mapKey, mapValue);
        }
        return map;
    }

    public Collection<String> getStrings(final String name) {
        Predicate<Object> is_collection_entry = new Predicate<Object>(){

            public boolean apply(Object key) {
                String oldStyle = ("CI-" + name + "-EntryValue").toLowerCase();
                String newStyle = ("CI-" + name).toLowerCase();
                String entryKey = key.toString().toLowerCase().trim();
                return entryKey.startsWith(oldStyle) || entryKey.startsWith(newStyle);
            }
        };
        Map filteredMap = Maps.filterKeys((Map)this.attributes, (Predicate)is_collection_entry);
        if (filteredMap.isEmpty()) {
            return Collections.emptyList();
        }
        List sortedKeys = Ordering.from((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o, Object o2) {
                return o.toString().compareTo(o2.toString());
            }
        }).sortedCopy(filteredMap.keySet());
        return Lists.transform((List)sortedKeys, (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return ManifestEntry.this.attributes.get(input).toString();
            }
        });
    }
}

