/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.validation;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class Validator {
    public List<ValidationMessage> validate(ConfigurationItem roe, ConfigurationItem ... cisInContext) {
        return this.validate(roe, Lists.newArrayList((Object[])cisInContext));
    }

    public List<ValidationMessage> validate(ConfigurationItem ci, List<ConfigurationItem> cisInContext) {
        return ci.getType().getDescriptor().validate(ci);
    }

    public void validateCi(ConfigurationItem item) throws ValidationsFailedException {
        List<ValidationMessage> messages = this.validate(item, new ConfigurationItem[0]);
        if (!messages.isEmpty()) {
            ValidatedConfigurationItem validatedConfigurationItem = new ValidatedConfigurationItem(item);
            validatedConfigurationItem.setValidations(messages);
            throw new ValidationsFailedException((ConfigurationItem)validatedConfigurationItem);
        }
    }

    public void validateCis(List<ConfigurationItem> entities) {
        ArrayList validated = Lists.newArrayList();
        boolean allValid = true;
        for (ConfigurationItem entity : entities) {
            List<ValidationMessage> messages = this.validate(entity, new ConfigurationItem[0]);
            if (!messages.isEmpty()) {
                ValidatedConfigurationItem e = new ValidatedConfigurationItem(entity);
                e.setValidations(messages);
                validated.add(e);
            } else {
                validated.add(entity);
            }
            allValid = allValid && messages.isEmpty();
        }
        if (!allValid) {
            throw new ValidationsFailedException(validated);
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class ValidationsFailedException
    extends DeployitException {
        public ValidationsFailedException(List<ConfigurationItem> cis) {
            super(cis);
        }

        public ValidationsFailedException(ConfigurationItem ci) {
            super((Object)ci);
        }
    }
}

