/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import java.util.Map;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.Subscribe;
import nl.javadude.t2bus.T2Bus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventBusAdapter {
    private T2Bus bus = new T2Bus();
    private Map<ExecutionStateListener, EventListenerAdapter> listeners = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(T2Bus.class);

    EventBusAdapter() {
    }

    void post(Object e, EventHandlerStrategy handler) {
        logger.debug("Post: {}", e);
        this.bus.post(e, handler);
    }

    void post(Object e) {
        logger.debug("Post: {}", e);
        this.bus.post(e);
    }

    static void tryRegister(Object value, EventBusAdapter bus) {
        if (value instanceof ExecutionStateListener && bus != null) {
            bus.register((ExecutionStateListener)value);
        }
    }

    void register(ExecutionStateListener l) {
        logger.debug("Registering event listener: {}", (Object)l);
        EventListenerAdapter a = new EventListenerAdapter(l);
        this.bus.register((Object)a);
        this.listeners.put(l, a);
    }

    void unregister(ExecutionStateListener l) {
        this.bus.unregister((Object)this.listeners.remove(l));
    }

    public static void tryUnregister(Object value, EventBusAdapter bus) {
        if (value instanceof ExecutionStateListener && bus != null) {
            bus.unregister((ExecutionStateListener)value);
        }
    }

    static class EventListenerAdapter {
        private ExecutionStateListener listener;

        public EventListenerAdapter(ExecutionStateListener listener) {
            this.listener = listener;
        }

        @Subscribe
        public void stepStateChanged(StepExecutionStateEvent event) {
            this.listener.stepStateChanged(event);
        }

        @Subscribe
        public void taskStateChanged(TaskExecutionStateEvent event) {
            this.listener.taskStateChanged(event);
        }
    }
}

