/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTime;

public class Task
implements Serializable,
TaskWithSteps {
    private List<TaskStep> steps;
    private final String id;
    private final String description;
    private DateTime startDate;
    private DateTime completionDate;
    private volatile TaskExecutionState state;
    private AtomicInteger failureCount;
    private AtomicInteger stepNr;
    private TaskExecutionContext context;
    private Map<String, String> metadata;
    private String owner;

    Task(List<TaskStep> steps, TaskSpecification spec) {
        this.steps = steps;
        this.description = spec.getDescription();
        this.metadata = spec.getMetadata();
        this.owner = spec.getOwner();
        this.id = UUID.randomUUID().toString();
        this.state = TaskExecutionState.PENDING;
        this.failureCount = new AtomicInteger(0);
        this.stepNr = new AtomicInteger(0);
        this.context = new TaskExecutionContext(spec.getListeners(), spec.getInspectionContext());
        if (spec.getInspectionContext() != null) {
            spec.getInspectionContext().registerTask(this);
        }
    }

    public List<StepState> getSteps() {
        return Lists.newArrayList(this.steps);
    }

    public List<TaskStep> getTaskSteps() {
        return this.steps;
    }

    public TaskExecutionState getState() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getCompletionDate() {
        return this.completionDate;
    }

    public int getNrSteps() {
        return this.steps.size();
    }

    public TaskStep getCurrentStep() {
        if (this.stepNr.intValue() == 0) {
            return null;
        }
        return this.getStep(this.stepNr.intValue());
    }

    public TaskStep getStep(int stepNr) {
        return this.steps.get(this.stepNrToIndex(stepNr));
    }

    int stepNrToIndex(int stepNr) {
        Preconditions.checkArgument((stepNr > 0 && stepNr <= this.steps.size() ? 1 : 0) != 0, (String)"Not a valid step number [%s]", (Object[])new Object[]{stepNr});
        return stepNr - 1;
    }

    public int getCurrentStepNr() {
        return this.stepNr.intValue();
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int getFailureCount() {
        return this.failureCount.intValue();
    }

    public TaskExecutionContext getContext() {
        return this.context;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    void recordFailure() {
        this.failureCount.incrementAndGet();
    }

    void recordStart() {
        if (this.startDate == null) {
            this.startDate = new DateTime();
        }
    }

    void recordCompletion() {
        this.completionDate = new DateTime();
    }

    boolean recordNextStep() {
        if (this.stepNr.get() < this.steps.size()) {
            this.stepNr.incrementAndGet();
            return true;
        }
        return false;
    }

    void setState(TaskExecutionState state) {
        this.state = state;
    }

    public String toString() {
        return this.id + " - " + this.description;
    }
}

