/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.GwtCompatible;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@Nullable String string2) {
        return string2 == null ? "" : string2;
    }

    @Nullable
    public static String emptyToNull(@Nullable String string2) {
        return Strings.isNullOrEmpty(string2) ? null : string2;
    }

    public static boolean isNullOrEmpty(@Nullable String string2) {
        return string2 == null || string2.length() == 0;
    }

    public static String padStart(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string2.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string2);
        return sb.toString();
    }

    public static String padEnd(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string2);
        for (int i = string2.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String repeat(String string2, int count) {
        Preconditions.checkNotNull(string2);
        Preconditions.checkArgument(count >= 0, "invalid count: %s", count);
        StringBuilder builder = new StringBuilder(string2.length() * count);
        for (int i = 0; i < count; ++i) {
            builder.append(string2);
        }
        return builder.toString();
    }
}

