/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.pool.validation;

import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.pool.DirContextType;
import org.springframework.ldap.pool.validation.DirContextValidator;

public class DefaultDirContextValidator
implements DirContextValidator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String base;
    private String filter;
    private SearchControls searchControls = new SearchControls();

    public DefaultDirContextValidator() {
        this(0);
    }

    public DefaultDirContextValidator(int searchScope) {
        this.searchControls.setSearchScope(searchScope);
        this.searchControls.setCountLimit(1L);
        this.searchControls.setReturningAttributes(new String[]{"objectclass"});
        this.searchControls.setTimeLimit(500);
        this.base = "";
        this.filter = "objectclass=*";
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter may not be null");
        }
        this.filter = filter;
    }

    public SearchControls getSearchControls() {
        return this.searchControls;
    }

    public void setSearchControls(SearchControls searchControls) {
        if (searchControls == null) {
            throw new IllegalArgumentException("searchControls may not be null");
        }
        this.searchControls = searchControls;
    }

    public boolean validateDirContext(DirContextType contextType, DirContext dirContext) {
        Validate.notNull((Object)contextType, (String)"contextType may not be null");
        Validate.notNull((Object)dirContext, (String)"dirContext may not be null");
        try {
            NamingEnumeration<SearchResult> searchResults = dirContext.search(this.base, this.filter, this.searchControls);
            if (searchResults.hasMore()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("DirContext '" + dirContext + "' passed validation."));
                }
                return true;
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("DirContext '" + dirContext + "' failed validation with an exception."), (Throwable)e);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("DirContext '" + dirContext + "' failed validation."));
        }
        return false;
    }
}

