Add-Type -AssemblyName System.Web

# set screen size

$pshost = get-host
$pswindow = $pshost.ui.rawui
$newsize = $pswindow.buffersize
$newsize.height = 3000
$newsize.width = 1024
$pswindow.buffersize = $newsize

# discovery functions

Function quote_plus($val) {
   [System.Web.HttpUtility]::UrlEncode($val)
}

Function discovered($id, $type) {
     Write-Output "DISCOVERED-ITEM:$(quote_plus($id)):$(quote_plus($type))"
}

Function inspectedProperty($id, $name, $value) {
    if ($value -is [array]) {
        foreach ($v in $value) {
           Write-Output "INSPECTED-PROPERTY:$(quote_plus($id)):$(quote_plus($name)):$(quote_plus($v))"
        }
    } elseif ($value -is [hashtable]) {
        foreach ($k in $value.Keys) {
            $v = $value[$k]
            if ($v -eq $null)
               { $v = "" }
            Write-Output "INSPECTED-PROPERTY:$(quote_plus($id)):$(quote_plus($name)):$(quote_plus($k)):$(quote_plus($v))"
        }
    } else {
        Write-Output "INSPECTED-PROPERTY:$(quote_plus($id)):$(quote_plus($name)):$(quote_plus($value))"
    }
}

Function inspected($name, $value) {
    inspectedProperty('this', $name, $value)
}

Function inspectedItem($id) {
    Write-Output "INSPECTED-ITEM:$(quote_plus($id))"
}


