/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.overthere.LegacyCifsConnectionType;
import com.xebialabs.deployit.plugin.overthere.step.CheckCommandExecutionStep;
import com.xebialabs.deployit.plugin.overthere.step.CheckFileTransferStep;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, virtual=true, description="Machine that runs middleware, on which scripts can be executed, etc.")
public class Host
extends BaseContainer
implements HostContainer {
    @Property(description="Protocol to use when connecting to this host", hidden=true)
    private String protocol;
    @Property(label="Operating system", description="Operating system the host runs")
    private OperatingSystemFamily os;
    @Property(category="Advanced", description="Directory into which temporary files are stored. Will be cleaned up when the connection is closed.", required=false)
    private String temporaryDirectoryPath;
    private static Logger logger = LoggerFactory.getLogger(Host.class);

    public OverthereConnection getConnection() {
        logger.debug("Using connection protocol {}", (Object)this.protocol);
        return Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.getConnectionOptions());
    }

    @ControlTask(label="Check connection", description="Checks whether Deployit can transfer files to and execute commands on this host.")
    public List<Step> checkConnection() {
        return Lists.newArrayList((Object[])new Step[]{new CheckFileTransferStep(this), new CheckCommandExecutionStep(this)});
    }

    @Override
    public Host getHost() {
        return this;
    }

    public OperatingSystemFamily getOs() {
        return this.os;
    }

    public void setOs(OperatingSystemFamily os) {
        this.os = os;
    }

    public String getTemporaryDirectoryPath() {
        return this.temporaryDirectoryPath;
    }

    public void setTemporaryDirectoryPath(String temporaryDirectoryPath) {
        this.temporaryDirectoryPath = temporaryDirectoryPath;
    }

    private ConnectionOptions getConnectionOptions() {
        return new ConnectionOptionsBuilder().getConnectionOptions(this);
    }

    public static class ConnectionOptionsBuilder {
        private List<String> seenJumpStations = Lists.newArrayList();

        public ConnectionOptions getConnectionOptions(Host host) {
            ConnectionOptions options = new ConnectionOptions();
            this.copyPropertiesToConnectionOptions(options, (ConfigurationItem)host);
            if (!Strings.nullToEmpty((String)host.getTemporaryDirectoryPath()).trim().isEmpty()) {
                this.setConnectionOption(options, "tmp", host.getTemporaryDirectoryPath());
            }
            logger.debug("Created connection options: {}", (Object)options);
            return options;
        }

        protected void copyPropertiesToConnectionOptions(ConnectionOptions options, ConfigurationItem ci) {
            for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
                Object value = pd.get(ci);
                this.setConnectionOption(options, pd.getName(), value);
            }
            this.fixLegacyCifsConnectionType(options);
        }

        private void setConnectionOption(ConnectionOptions options, String key, Object value) {
            if (key.equals("protocol") || key.equals("temporaryDirectoryPath")) {
                return;
            }
            if (value == null || Strings.isNullOrEmpty((String)value.toString())) {
                return;
            }
            boolean isJumpStationOption = key.equals("jumpstation");
            if (isJumpStationOption && !this.jumpedThroughAlready((ConfigurationItem)value)) {
                ConnectionOptions jumpstationOptions = new ConnectionOptions();
                this.copyPropertiesToConnectionOptions(jumpstationOptions, (ConfigurationItem)value);
                options.set(key, (Object)jumpstationOptions);
            } else if (!isJumpStationOption) {
                options.set(key, value);
            }
        }

        private void fixLegacyCifsConnectionType(ConnectionOptions options) {
            Object connectionType = options.getOptional("connectionType");
            if (connectionType instanceof LegacyCifsConnectionType) {
                switch ((LegacyCifsConnectionType)((Object)connectionType)) {
                    case TELNET: {
                        connectionType = CifsConnectionType.TELNET;
                        break;
                    }
                    case WINRM: {
                        connectionType = CifsConnectionType.WINRM;
                        break;
                    }
                    case WINRM_HTTP: {
                        logger.warn("Translating legacy CIFS connection type " + (Object)((Object)LegacyCifsConnectionType.WINRM_HTTP) + " to new type " + CifsConnectionType.WINRM + " and setting " + "winrmEnableHttps" + " option to false");
                        connectionType = CifsConnectionType.WINRM;
                        options.set("winrmEnableHttps", (Object)false);
                        break;
                    }
                    case WINRM_HTTPS: {
                        logger.warn("Translating legacy CIFS connection type " + (Object)((Object)LegacyCifsConnectionType.WINRM_HTTPS) + " to new type " + CifsConnectionType.WINRM + " and setting " + "winrmEnableHttps" + " option to true");
                        connectionType = CifsConnectionType.WINRM;
                        options.set("winrmEnableHttps", (Object)true);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Unknown value [%s] for property [%s] of type " + LegacyCifsConnectionType.class.getName(), connectionType, connectionType));
                    }
                }
                options.set("connectionType", connectionType);
            }
        }

        private boolean jumpedThroughAlready(ConfigurationItem value) {
            if (this.seenJumpStations.contains(value.getId())) {
                this.seenJumpStations.add(value.getId());
                String listOfStations = Joiner.on((String)" -> ").join(this.seenJumpStations);
                throw new IllegalStateException("Detected loop in jumpstations: " + listOfStations);
            }
            this.seenJumpStations.add(value.getId());
            return false;
        }
    }
}

