/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.ArchiveTaskTrigger;
import com.xebialabs.deployit.engine.tasker.OldExecutionContextListenerCleanupTrigger;
import com.xebialabs.deployit.engine.tasker.Registry;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskRecoveryTrigger;
import com.xebialabs.deployit.engine.tasker.TaskRunner;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;

public class Engine {
    static final AtomicReference<Registry> REGISTRY_REF = new AtomicReference();
    static final AtomicReference<Archive> ARCHIVE_REF = new AtomicReference();
    private TaskExecutor taskExecutor;
    private File recoveryDir;
    private RepositoryFactory repository;
    private static final Logger logger = LoggerFactory.getLogger(Engine.class);

    public Engine(Registry registry, Archive archive, TaskExecutor taskExecutor, String recoveryDir, RepositoryFactory repository) {
        REGISTRY_REF.set(registry);
        ARCHIVE_REF.set(archive);
        this.taskExecutor = taskExecutor;
        this.recoveryDir = new File(recoveryDir);
        this.repository = repository;
    }

    public String register(TaskSpecification spec) {
        this.registerDefaultTriggers(spec);
        Task task = new Task(spec.getSteps(), spec);
        this.registerTask(task);
        this.getTaskRunner(task.getId()).pending();
        return task.getId();
    }

    private void registerTask(Task task) {
        REGISTRY_REF.get().register(new TaskRunner(task, this.repository));
    }

    private void registerDefaultTriggers(TaskSpecification spec) {
        spec.getListeners().add(new ArchiveTaskTrigger());
        spec.getListeners().add(new TaskRecoveryTrigger(this.recoveryDir));
        spec.getListeners().add(new OldExecutionContextListenerCleanupTrigger());
    }

    public Task retrieve(String taskid) {
        TaskRunner retrieve = this.getTaskRunner(taskid);
        return retrieve == null ? null : retrieve.getTask();
    }

    public void execute(String taskid) {
        TaskRunner runner = this.getTaskRunner(taskid);
        Preconditions.checkState((runner != null ? 1 : 0) != 0, (String)"No task registered with id [%s]", (Object[])new Object[]{taskid});
        runner.queue();
        FutureTask<Object> future = new FutureTask<Object>(runner, null);
        runner.setThreadHandle(future);
        this.taskExecutor.execute(future);
    }

    public void abort(String taskid) {
        this.getTaskRunner(taskid).abort();
    }

    public void stop(String taskid) {
        this.getTaskRunner(taskid).stop();
    }

    public void cancel(String taskid) {
        this.getTaskRunner(taskid).cancel();
    }

    public void skipSteps(String taskid, List<Integer> stepNrs) {
        TaskRunner runner = this.getTaskRunner(taskid);
        for (Integer stepNr : stepNrs) {
            runner.skip(stepNr);
        }
    }

    public void unskipSteps(String taskid, List<Integer> stepNrs) {
        TaskRunner runner = this.getTaskRunner(taskid);
        for (Integer stepNr : stepNrs) {
            runner.unskip(stepNr);
        }
    }

    public void moveStep(String taskid, int stepNr, int newPosition) {
        TaskRunner runner = this.getTaskRunner(taskid);
        runner.moveStep(stepNr, newPosition);
    }

    public void addPauseStep(String taskid, int position) {
        this.getTaskRunner(taskid).addPause(position);
    }

    public List<Task> getAllIncompleteTasks() {
        logger.debug("Finding all incomplete tasks");
        ArrayList tasks = Lists.newArrayList();
        for (TaskRunner eachRunner : REGISTRY_REF.get().tasks()) {
            Task eachTask = eachRunner.getTask();
            logger.debug("Considering task {}", (Object)eachTask);
            if (!EnumSet.of(TaskExecutionState.PENDING, TaskExecutionState.QUEUED, TaskExecutionState.STOPPED, TaskExecutionState.EXECUTING, TaskExecutionState.EXECUTED).contains(eachTask.getState())) continue;
            logger.debug("Returning task [{}] because it's PENDING, STOPPED or EXECUTING", (Object)eachTask);
            tasks.add(eachTask);
        }
        logger.debug("Returning [{}] tasks", (Object)tasks.size());
        return tasks;
    }

    public void archive(String taskid) {
        this.getTaskRunner(taskid).archive();
    }

    private TaskRunner getTaskRunner(String taskid) {
        return REGISTRY_REF.get().retrieve(taskid);
    }

    /*
     * Exception decompiling
     */
    @PostConstruct
    public void recoverTasks() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setRecoveryState(Task t) {
        if (!EnumSet.of(TaskExecutionState.PENDING, TaskExecutionState.EXECUTED).contains(t.getState())) {
            t.setState(TaskExecutionState.STOPPED);
        }
        for (TaskStep step : t.getTaskSteps()) {
            if (step.getState() != StepExecutionState.EXECUTING) continue;
            step.setState(StepExecutionState.FAILED);
        }
    }

    private void createRecoveryDir() {
        if (!this.recoveryDir.exists() && !this.recoveryDir.mkdir()) {
            throw new IllegalStateException("Could not create the recovery dir: " + this.recoveryDir);
        }
        if (this.recoveryDir.exists() && !this.recoveryDir.isDirectory()) {
            throw new IllegalStateException("A file exists with the name of the recovery dir, please delete it (" + this.recoveryDir + ")");
        }
    }

    @PreDestroy
    public void shutdownTasks() {
        this.requestStopOnTasks();
        this.waitForTasksToBeStopped();
    }

    private void waitForTasksToBeStopped() {
        for (TaskRunner task : REGISTRY_REF.get().tasks()) {
            if (!task.isExecuting()) continue;
            try {
                logger.info("Waiting for task {} to stop", (Object)task.getTask().getId());
                FutureTask<Object> wrappingTask = task.getThreadHandle();
                if (wrappingTask == null) continue;
                wrappingTask.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                logger.error("Could not wait for task {} to be stopped...", (Object)task.getTask().getId());
            }
        }
    }

    private void requestStopOnTasks() {
        for (TaskRunner task : REGISTRY_REF.get().tasks()) {
            if (!task.isExecuting()) continue;
            task.stop();
        }
    }
}

