/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating.manager;

import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.transaction.compensating.LdapCompensatingTransactionOperationFactory;
import org.springframework.ldap.transaction.compensating.TempEntryRenamingStrategy;
import org.springframework.ldap.transaction.compensating.manager.DirContextHolder;
import org.springframework.ldap.transaction.compensating.manager.TransactionAwareContextSourceProxy;
import org.springframework.ldap.transaction.compensating.support.DefaultTempEntryRenamingStrategy;
import org.springframework.transaction.compensating.support.AbstractCompensatingTransactionManagerDelegate;
import org.springframework.transaction.compensating.support.CompensatingTransactionHolderSupport;
import org.springframework.transaction.compensating.support.DefaultCompensatingTransactionOperationManager;

public class ContextSourceTransactionManagerDelegate
extends AbstractCompensatingTransactionManagerDelegate {
    private static final Log log = LogFactory.getLog((Class)ContextSourceTransactionManagerDelegate.class);
    private ContextSource contextSource;
    private TempEntryRenamingStrategy renamingStrategy = new DefaultTempEntryRenamingStrategy();

    public void setContextSource(ContextSource contextSource) {
        if (contextSource instanceof TransactionAwareContextSourceProxy) {
            TransactionAwareContextSourceProxy proxy = (TransactionAwareContextSourceProxy)contextSource;
            this.contextSource = proxy.getTarget();
        } else {
            this.contextSource = contextSource;
        }
    }

    public ContextSource getContextSource() {
        return this.contextSource;
    }

    protected Object getTransactionSynchronizationKey() {
        return this.getContextSource();
    }

    protected CompensatingTransactionHolderSupport getNewHolder() {
        DirContext newCtx = this.getContextSource().getReadWriteContext();
        DirContextHolder contextHolder = new DirContextHolder(new DefaultCompensatingTransactionOperationManager(new LdapCompensatingTransactionOperationFactory(this.renamingStrategy)), newCtx);
        return contextHolder;
    }

    protected void closeTargetResource(CompensatingTransactionHolderSupport transactionHolderSupport) {
        DirContextHolder contextHolder = (DirContextHolder)transactionHolderSupport;
        DirContext ctx = contextHolder.getCtx();
        try {
            log.debug((Object)"Closing target context");
            ctx.close();
        }
        catch (NamingException e) {
            log.warn((Object)"Failed to close target context", (Throwable)e);
        }
    }

    public void setRenamingStrategy(TempEntryRenamingStrategy renamingStrategy) {
        this.renamingStrategy = renamingStrategy;
    }
}

