/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.CharConversionException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsCovariantEntry<E extends FsArchiveEntry>
extends FsEntry
implements Cloneable {
    private final String name;
    private EnumMap<Entry.Type, E> map = new EnumMap(Entry.Type.class);
    @Nullable
    private Entry.Type key;
    @Nullable
    private LinkedHashSet<String> members;

    public FsCovariantEntry(String path) {
        this.name = path.toString();
    }

    public FsCovariantEntry<E> clone(FsArchiveDriver<E> driver) {
        FsCovariantEntry that;
        try {
            that = (FsCovariantEntry)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
        that.map = new EnumMap<Entry.Type, E>(Entry.Type.class);
        EnumMap<Entry.Type, E> thatMap = that.map;
        try {
            for (Map.Entry<Entry.Type, E> entry : this.map.entrySet()) {
                FsArchiveEntry delegate = (FsArchiveEntry)entry.getValue();
                thatMap.put(entry.getKey(), driver.newEntry(delegate.getName(), delegate.getType(), delegate));
            }
        }
        catch (CharConversionException ex) {
            throw new AssertionError((Object)ex);
        }
        LinkedHashSet<String> members = this.members;
        if (null != members) {
            that.members = (LinkedHashSet)members.clone();
        }
        return that;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Nullable
    public Entry.Type getKey() {
        return this.key;
    }

    public void setKey(@Nullable Entry.Type type) {
        this.key = type;
    }

    @Nullable
    public E putEntry(Entry.Type type, E entry) {
        this.key = type;
        return (E)((FsArchiveEntry)this.map.put(this.key, entry));
    }

    @Nullable
    public E removeEntry(Entry.Type type) {
        return (E)((FsArchiveEntry)this.map.remove((Object)type));
    }

    @Nullable
    public E getEntry(Entry.Type type) {
        return (E)((FsArchiveEntry)this.map.get((Object)type));
    }

    @Nullable
    public E getEntry() {
        return (E)((FsArchiveEntry)this.map.get((Object)this.key));
    }

    public Collection<E> getEntries() {
        return this.map.values();
    }

    @Override
    public Set<Entry.Type> getTypes() {
        return this.map.keySet();
    }

    @Override
    public boolean isType(Entry.Type type) {
        return this.map.containsKey((Object)type);
    }

    @Override
    public long getSize(Entry.Size type) {
        if (Entry.Type.DIRECTORY == this.key) {
            return -1L;
        }
        return ((FsArchiveEntry)this.map.get((Object)this.key)).getSize(type);
    }

    @Override
    public long getTime(Entry.Access type) {
        return ((FsArchiveEntry)this.map.get((Object)this.key)).getTime(type);
    }

    @Override
    @Nullable
    public Set<String> getMembers() {
        if (!this.map.containsKey((Object)Entry.Type.DIRECTORY)) {
            this.members = null;
            return null;
        }
        LinkedHashSet<String> members = this.members;
        return null != members ? members : (this.members = new LinkedHashSet());
    }

    public boolean add(String member) {
        return this.getMembers().add(member);
    }

    public boolean remove(String member) {
        return this.getMembers().remove(member);
    }
}

