/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpEntityMethodProcessor
extends AbstractMessageConverterMethodProcessor {
    public HttpEntityMethodProcessor(List<HttpMessageConverter<?>> messageConverters) {
        super(messageConverters);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class parameterType = parameter.getParameterType();
        return HttpEntity.class.equals((Object)parameterType);
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        Class parameterType = returnType.getParameterType();
        return HttpEntity.class.isAssignableFrom(parameterType) || ResponseEntity.class.isAssignableFrom(parameterType);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws IOException, HttpMediaTypeNotSupportedException {
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        Class<?> paramType = this.getHttpEntityType(parameter);
        Object body = this.readWithMessageConverters(webRequest, parameter, paramType);
        return new HttpEntity(body, (MultiValueMap)inputMessage.getHeaders());
    }

    private Class<?> getHttpEntityType(MethodParameter parameter) {
        Assert.isAssignable(HttpEntity.class, (Class)parameter.getParameterType());
        ParameterizedType type = (ParameterizedType)parameter.getGenericParameterType();
        if (type.getActualTypeArguments().length == 1) {
            Type componentType;
            Type typeArgument = type.getActualTypeArguments()[0];
            if (typeArgument instanceof Class) {
                return (Class)typeArgument;
            }
            if (typeArgument instanceof GenericArrayType && (componentType = ((GenericArrayType)typeArgument).getGenericComponentType()) instanceof Class) {
                Object array = Array.newInstance((Class)componentType, 0);
                return array.getClass();
            }
        }
        throw new IllegalArgumentException("HttpEntity parameter (" + parameter.getParameterName() + ") " + "in method " + parameter.getMethod() + "is not parameterized");
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Object body;
        HttpHeaders entityHeaders;
        mavContainer.setRequestHandled(true);
        if (returnValue == null) {
            return;
        }
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        Assert.isInstanceOf(HttpEntity.class, (Object)returnValue);
        HttpEntity responseEntity = (HttpEntity)returnValue;
        if (responseEntity instanceof ResponseEntity) {
            outputMessage.setStatusCode(((ResponseEntity)responseEntity).getStatusCode());
        }
        if (!(entityHeaders = responseEntity.getHeaders()).isEmpty()) {
            outputMessage.getHeaders().putAll((Map)entityHeaders);
        }
        if ((body = responseEntity.getBody()) != null) {
            this.writeWithMessageConverters(body, returnType, inputMessage, outputMessage);
        } else {
            outputMessage.getBody();
        }
    }
}

