/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.file.FileEntry;
import de.schlichtherle.truezip.io.IOExceptionOutputStream;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@DefaultAnnotation(value={NonNull.class})
final class FileOutputSocket
extends OutputSocket<FileEntry> {
    private final FileEntry entry;
    private final BitField<FsOutputOption> options;
    @CheckForNull
    private final Entry template;

    FileOutputSocket(FileEntry entry, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        assert (null != entry);
        assert (null != options);
        if (options.get((Enum)FsOutputOption.EXCLUSIVE) && options.get((Enum)FsOutputOption.APPEND)) {
            throw new IllegalArgumentException();
        }
        this.entry = entry;
        this.options = options;
        this.template = template;
    }

    public FileEntry getLocalTarget() {
        return this.entry;
    }

    private FileEntry begin() throws IOException {
        File parentFile;
        FileEntry temp;
        File entryFile = this.entry.getFile();
        Boolean exists = null;
        if (this.options.get((Enum)FsOutputOption.EXCLUSIVE) && (exists = Boolean.valueOf(entryFile.exists())).booleanValue()) {
            throw new IOException(entryFile + " (file exists already)");
        }
        if (this.options.get((Enum)FsOutputOption.CACHE)) {
            if ((Boolean.TRUE.equals(exists) || null == exists && (exists = Boolean.valueOf(entryFile.exists())).booleanValue()) && !entryFile.canWrite()) {
                throw new FileNotFoundException(entryFile + " (cannot write)");
            }
            temp = this.entry.createTempFile();
        } else {
            temp = this.entry;
        }
        if (this.options.get((Enum)FsOutputOption.CREATE_PARENTS) && !Boolean.TRUE.equals(exists) && null != (parentFile = entryFile.getParentFile()) && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException(parentFile + " (cannot create directories)");
        }
        return temp;
    }

    private void append(FileEntry temp) throws IOException {
        if (temp != this.entry && this.options.get((Enum)FsOutputOption.APPEND) && this.entry.getFile().exists()) {
            IOSocket.copy(this.entry.getInputSocket(), temp.getOutputSocket());
        }
    }

    private void close(FileEntry temp, boolean commit) throws IOException {
        File entryFile = this.entry.getFile();
        if (temp != this.entry) {
            File tempFile = temp.getFile();
            this.copyAttributes(tempFile);
            if (commit) {
                if (!FileOutputSocket.move(tempFile, entryFile)) {
                    IOSocket.copy(temp.getInputSocket(), this.entry.getOutputSocket());
                    this.copyAttributes(entryFile);
                }
                this.release(temp, null);
            }
        } else {
            this.copyAttributes(entryFile);
        }
    }

    private void copyAttributes(File file) throws IOException {
        Entry template = this.template;
        if (null == template) {
            return;
        }
        long time = template.getTime(Entry.Access.WRITE);
        if (-1L != time && !file.setLastModified(time)) {
            throw new IOException(file + " (cannot preserve last modification time)");
        }
    }

    private static boolean move(File src, File dst) {
        return src.exists() && (!dst.exists() || dst.delete()) && src.renameTo(dst);
    }

    private void release(FileEntry temp, @CheckForNull IOException ex) throws IOException {
        try {
            temp.release();
        }
        catch (IOException ex2) {
            ex2.initCause(ex);
            throw ex2;
        }
    }

    public OutputStream newOutputStream() throws IOException {
        final FileEntry temp = this.begin();
        try {
            this.append(temp);
            class OutputStream
            extends IOExceptionOutputStream {
                boolean closed;

                OutputStream() throws FileNotFoundException {
                    super((java.io.OutputStream)new FileOutputStream(fileEntry.getFile(), FileOutputSocket.this.options.get((Enum)FsOutputOption.APPEND)));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        super.close();
                        FileOutputSocket.this.close(temp, null == this.exception);
                    }
                    catch (Throwable throwable) {
                        FileOutputSocket.this.close(temp, null == this.exception);
                        throw throwable;
                    }
                }
            }
            return new OutputStream();
        }
        catch (IOException ex) {
            this.release(temp, ex);
            throw ex;
        }
    }
}

