/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.Interpreter;
import com.xebialabs.deployit.cli.ScriptEngineBuilder;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.help.HelpScanner;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.ScriptException;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cli {
    private static final AtomicReference<Properties> properties = new AtomicReference();
    private static ConsoleReader consoleReader;
    private static final FilenameFilter CLI_EXTENSION_FILTER;
    private ScriptEngineBuilder scriptEngine;
    private CliOptions options;
    private DeployitCommunicator communicator;
    private static final Logger logger;

    public Cli(CliOptions options) throws Exception {
        this.options = options;
        this.scriptEngine = new ScriptEngineBuilder();
        this.initialize();
    }

    private void printBanner() {
        this.bannerPrint("Welcome to the Deployit Jython CLI!");
        this.bannerPrint("Type 'help' to learn about the objects you can use to interact with Deployit.");
        this.bannerPrint("");
    }

    private void initialize() throws Exception {
        BooterConfig.Builder builder = BooterConfig.builder().withHost(this.options.getHost()).withContext(this.options.getContext()).withPort(this.options.getPort());
        if (this.options.isSecured()) {
            builder.withProtocol(BooterConfig.Protocol.HTTPS);
        }
        this.createCredentials(builder);
        BooterConfig config = builder.build();
        RemoteBooter.boot((BooterConfig)config);
        this.communicator = RemoteBooter.getCommunicator((BooterConfig)config);
        this.printBanner();
        ProxiesInstance proxies = this.createAndRegisterProxies(config);
        this.registerCliObjects(proxies);
    }

    private ProxiesInstance createAndRegisterProxies(BooterConfig config) {
        ProxiesInstance proxies = new ProxiesInstance(config);
        if (this.options.isExposeProxies()) {
            System.out.println("Exposing Proxies!");
            this.scriptEngine.put("proxies", proxies);
        }
        return proxies;
    }

    public static void main(String[] args) throws Exception {
        CliOptions options = CliOptions.parse(args);
        if (options == null) {
            return;
        }
        consoleReader = Cli.setupConsole();
        new Cli(options).getNewInterpreter().interpret();
    }

    private static ConsoleReader setupConsole() throws IOException {
        final Terminal terminal = Cli.getTerminal();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    terminal.restore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ConsoleReader cr = new ConsoleReader();
        cr.setExpandEvents(false);
        return cr;
    }

    private static Terminal getTerminal() {
        Terminal terminal;
        try {
            terminal = TerminalFactory.create();
        }
        catch (Throwable t) {
            System.err.println("[WARNING] Error loading terminal, using fallback. Your terminal will have reduced functionality. Please see: http://docs.xebialabs.com/general/faq.html#fallback-terminal");
            logger.warn("Error loading terminal, using fallback. Your terminal will have reduced functionality.");
            TerminalFactory.configure((TerminalFactory.Type)TerminalFactory.Type.NONE);
            terminal = TerminalFactory.create();
        }
        return terminal;
    }

    public Interpreter getNewInterpreter() throws ScriptException, FileNotFoundException {
        Interpreter interpreter = new Interpreter(consoleReader, this.scriptEngine, this.communicator, this.options);
        this.readExtensions(interpreter);
        return interpreter;
    }

    private void registerCliObjects(ProxiesInstance proxies) throws Exception {
        Scannit scannit = new Scannit(Configuration.config().with(new AbstractScanner[]{new TypeAnnotationScanner()}).scan("com.xebialabs"));
        Set classes = scannit.getTypesAnnotatedWith(CliObject.class);
        for (Class cliObject : classes) {
            Constructor constructor = cliObject.getConstructor(ProxiesInstance.class);
            Object o = constructor.newInstance(proxies);
            String name = cliObject.getAnnotation(CliObject.class).name();
            this.scriptEngine.put(name, o);
        }
        HelpScanner.init(classes);
        if (!this.options.isQuiet()) {
            HelpScanner.printHelp();
        }
    }

    public void createCredentials(BooterConfig.Builder builder) throws IOException {
        String username = this.options.isUsernameOnCommandline() ? this.options.getUsername() : (this.deployitConfigurationFileExists() ? this.readFromProperties("cli.username") : consoleReader.readLine("Username: "));
        String password = this.options.isPasswordOnCommandline() ? this.options.getPassword() : (this.deployitConfigurationFileExists() ? this.readFromProperties("cli.password") : consoleReader.readLine("Password: ", Character.valueOf('\u0000')));
        builder.withCredentials(username, password);
    }

    private boolean deployitConfigurationFileExists() {
        return this.options.getConfigurationFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromProperties(String key) throws IOException {
        if (properties.get() == null) {
            Properties props = new Properties();
            FileInputStream inStream = new FileInputStream(this.options.getConfigurationFile());
            try {
                props.load(inStream);
            }
            finally {
                Closeables.closeQuietly((Closeable)inStream);
            }
            properties.set(props);
        }
        return properties.get().getProperty(key);
    }

    private void readExtensions(Interpreter interpreter) throws ScriptException, FileNotFoundException {
        File[] files;
        File extensionDir = new File("ext");
        if (!extensionDir.exists() || !extensionDir.isDirectory()) {
            System.out.println("No extension directory present.");
            return;
        }
        for (File extension : files = extensionDir.listFiles(CLI_EXTENSION_FILTER)) {
            this.bannerPrint("Reading extension: " + extension);
            interpreter.evaluate(new FileReader(extension));
        }
    }

    void bannerPrint(String line) {
        if (!this.options.isQuiet()) {
            System.out.println(line);
        }
    }

    static {
        CLI_EXTENSION_FILTER = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".py") || name.endsWith(".cli");
            }
        };
        logger = LoggerFactory.getLogger(Cli.class);
    }
}

