/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.trigger;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.trigger.StepTrigger;
import com.xebialabs.deployit.plugin.trigger.TaskTrigger;
import com.xebialabs.deployit.plugin.trigger.Trigger;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="trigger")
@Target(value={ElementType.TYPE})
public @interface TriggerValidator {

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Trigger> {
        public void validate(Trigger trigger, ValidationContext context) {
            if (!this.isRequiredValuesFilled(trigger, context)) {
                return;
            }
            if (trigger instanceof StepTrigger) {
                StepTrigger stepTrigger = (StepTrigger)trigger;
                if (!stepTrigger.getFromState().isValidTransition(stepTrigger.getToState())) {
                    context.error("Not a valid step state transition. %s cannot transition to %s", new Object[]{stepTrigger.getFromState(), stepTrigger.getToState()});
                }
            } else {
                TaskTrigger taskTrigger = (TaskTrigger)trigger;
                if (!taskTrigger.getFromState().isValidTransition(taskTrigger.getToState())) {
                    context.error("Not a valid task state transition. %s cannot transition to %s", new Object[]{taskTrigger.getFromState(), taskTrigger.getToState()});
                }
            }
        }

        private boolean isRequiredValuesFilled(Trigger trigger, ValidationContext context) {
            boolean isRequiredValuesFilled = true;
            if (trigger.getFromState() == null) {
                context.error("FromState value is required", new Object[0]);
                isRequiredValuesFilled = false;
            }
            if (trigger.getToState() == null) {
                context.error("ToState value is required", new Object[0]);
                isRequiredValuesFilled = false;
            }
            return isRequiredValuesFilled;
        }
    }
}

