/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeployedArtifactPlaceholdersResolver;
import com.xebialabs.deployit.service.deployment.DeployedPropertySetter;
import com.xebialabs.deployit.service.deployment.ManualTagMatcher;
import com.xebialabs.deployit.service.deployment.TagMatcher;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedGenerator {
    private TypeCalculator calculator;
    private TagMatcher tagMatcher;
    private DeployedArtifactPlaceholdersResolver placeholdersResolver;
    private DeployedPropertySetter deployedPropertySetter;
    private final ManualTagMatcher manualTagMatcher;

    @Autowired
    public DeployedGenerator(TypeCalculator calculator, DeployedArtifactPlaceholdersResolver placeholdersResolver, DeployedPropertySetter deployedPropertySetter) {
        this.calculator = calculator;
        this.placeholdersResolver = placeholdersResolver;
        this.deployedPropertySetter = deployedPropertySetter;
        this.tagMatcher = new TagMatcher();
        this.manualTagMatcher = new ManualTagMatcher();
    }

    public Deployed<?, ?> createMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary dictionary) {
        return this.generateMostSpecificDeployed(deployable, container, dictionary, this.manualTagMatcher);
    }

    public Deployed<?, ?> autoGenerateMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary dictionary) {
        return this.generateMostSpecificDeployed(deployable, container, dictionary, this.tagMatcher);
    }

    public Deployed<?, ?> generateDeployed(Deployable deployable, Container container, Type deployedType, ConsolidatedDictionary dictionary) {
        Deployed<Deployable, Container> deployed = this.basicDeployed(deployable, container, deployedType, dictionary);
        this.deployedPropertySetter.setProperties((EmbeddedDeployedContainer)deployed, null, dictionary);
        this.placeholdersResolver.resolvePlaceholders(deployed, null, dictionary);
        return deployed;
    }

    private Deployed<?, ?> generateMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary dictionary, TagMatcher tagMatcher) {
        Type deployedType = this.calculator.findMostSpecificDeployedTypeForDeployableAndContainerTypes(deployable.getType(), container.getType());
        if (deployedType != null && tagMatcher.areMatching(deployable, container)) {
            return this.generateDeployed(deployable, container, deployedType, dictionary);
        }
        return null;
    }

    private Deployed<Deployable, Container> basicDeployed(Deployable deployable, Container container, Type deployedType, ConsolidatedDictionary dictionary) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)deployedType);
        Deployed deployed = (Deployed)deployedDesc.newInstance(IdGenerator.generateId((ConfigurationItem)container, (ConfigurationItem)deployable));
        deployed.setDeployable(deployable);
        deployed.setContainer(container);
        try {
            dictionary.resolveDeployedName((EmbeddedDeployedContainer)deployed);
        }
        catch (DictionaryValueException e) {
            throw new IncorrectDeployedException(e, "Couldn't generate name for deployed from [%s]", deployable.getName());
        }
        return deployed;
    }

    public Deployed<?, ?> generateUpgradedDeployed(Deployable newDeployable, Deployed<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        Deployed<Deployable, Container> upgradedDeployed = this.createUpgradedDeployed(newDeployable, existingDeployed, dictionary);
        this.deployedPropertySetter.setProperties((EmbeddedDeployedContainer)upgradedDeployed, (EmbeddedDeployedContainer)existingDeployed, dictionary);
        this.placeholdersResolver.resolvePlaceholders(upgradedDeployed, existingDeployed, dictionary);
        return upgradedDeployed;
    }

    private Deployed<Deployable, Container> createUpgradedDeployed(Deployable newDeployable, Deployed<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        Type newDeployableType;
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)existingDeployed.getType());
        Type deployableType = deployedDesc.getDeployableType();
        Checks.checkArgument((deployableType.equals((Object)(newDeployableType = newDeployable.getType())) || DescriptorRegistry.getSubtypes((Type)deployableType).contains(newDeployableType) ? 1 : 0) != 0, (String)"The new Deployable type %s should be assignable to %s", (Object[])new Object[]{newDeployableType, deployableType});
        boolean deployableNameHasPlaceholders = MustachePlaceholderScanner.hasPlaceholders((String)newDeployable.getName());
        String deployedId = existingDeployed.getId();
        if (deployableNameHasPlaceholders) {
            deployedId = IdGenerator.generateId((ConfigurationItem)existingDeployed.getContainer(), (ConfigurationItem)newDeployable);
        }
        Deployed upgradedDeployed = (Deployed)deployedDesc.newInstance(deployedId);
        upgradedDeployed.setDeployable(newDeployable);
        upgradedDeployed.setContainer(existingDeployed.getContainer());
        if (deployableNameHasPlaceholders) {
            try {
                dictionary.resolveDeployedName((EmbeddedDeployedContainer)upgradedDeployed);
            }
            catch (DictionaryValueException e) {
                throw new IncorrectDeployedException(e, "Couldn't generate name for deployed from [%s]", newDeployable.getId());
            }
        }
        return upgradedDeployed;
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class IncorrectDeployedException
    extends DeployitException {
        IncorrectDeployedException(Throwable cause, String messageTemplate, Object ... params) {
            super(cause, messageTemplate, params);
        }
    }
}

