/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.id;

import java.util.Random;
import java.util.UUID;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.SeededSecureRandom;

public class NodeId
implements ItemId,
Comparable<NodeId> {
    private static final long serialVersionUID = 5773949574212570258L;
    public static final int UUID_FORMATTED_LENGTH = 36;
    public static final int UUID_BYTE_LENGTH = 16;
    private final long msb;
    private final long lsb;

    public static NodeId valueOf(String uuid) throws IllegalArgumentException {
        if (uuid != null) {
            return new NodeId(uuid);
        }
        throw new IllegalArgumentException("NodeId.valueOf(null)");
    }

    public NodeId(long msb, long lsb) {
        this.msb = msb;
        this.lsb = lsb;
    }

    public NodeId(byte[] bytes) throws NullPointerException, ArrayIndexOutOfBoundsException {
        this((((long)bytes[0] & 0xFFL) << 56) + (((long)bytes[1] & 0xFFL) << 48) + (((long)bytes[2] & 0xFFL) << 40) + (((long)bytes[3] & 0xFFL) << 32) + (((long)bytes[4] & 0xFFL) << 24) + (((long)bytes[5] & 0xFFL) << 16) + (((long)bytes[6] & 0xFFL) << 8) + ((long)bytes[7] & 0xFFL), (((long)bytes[8] & 0xFFL) << 56) + (((long)bytes[9] & 0xFFL) << 48) + (((long)bytes[10] & 0xFFL) << 40) + (((long)bytes[11] & 0xFFL) << 32) + (((long)bytes[12] & 0xFFL) << 24) + (((long)bytes[13] & 0xFFL) << 16) + (((long)bytes[14] & 0xFFL) << 8) + ((long)bytes[15] & 0xFFL));
    }

    public NodeId(UUID uuid) {
        this(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public NodeId(String uuidString) throws IllegalArgumentException {
        if (uuidString.length() != 36) {
            throw new IllegalArgumentException(uuidString);
        }
        long m = 0L;
        long x = 0L;
        block4: for (int i = 0; i < 36; ++i) {
            char c = uuidString.charAt(i);
            switch (i) {
                case 18: {
                    m = x;
                    x = 0L;
                }
                case 8: 
                case 13: 
                case 23: {
                    if (c == '-') continue block4;
                    throw new IllegalArgumentException(uuidString);
                }
                default: {
                    if (c >= '0' && c <= '9') {
                        x = x << 4 | (long)(c - 48);
                        continue block4;
                    }
                    if (c >= 'a' && c <= 'f') {
                        x = x << 4 | (long)(c - 97 + 10);
                        continue block4;
                    }
                    if (c >= 'A' && c <= 'F') {
                        x = x << 4 | (long)(c - 65 + 10);
                        continue block4;
                    }
                    throw new IllegalArgumentException(uuidString);
                }
            }
        }
        this.msb = m;
        this.lsb = x;
    }

    public static NodeId randomId() {
        Random random = SeededSecureRandom.getInstance();
        return new NodeId(random.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L, random.nextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE);
    }

    public long getMostSignificantBits() {
        return this.msb;
    }

    public long getLeastSignificantBits() {
        return this.lsb;
    }

    public byte[] getRawBytes() {
        return new byte[]{(byte)(this.msb >> 56), (byte)(this.msb >> 48), (byte)(this.msb >> 40), (byte)(this.msb >> 32), (byte)(this.msb >> 24), (byte)(this.msb >> 16), (byte)(this.msb >> 8), (byte)this.msb, (byte)(this.lsb >> 56), (byte)(this.lsb >> 48), (byte)(this.lsb >> 40), (byte)(this.lsb >> 32), (byte)(this.lsb >> 24), (byte)(this.lsb >> 16), (byte)(this.lsb >> 8), (byte)this.lsb};
    }

    @Override
    public boolean denotesNode() {
        return true;
    }

    @Override
    public int compareTo(NodeId that) {
        if (this.msb < that.msb) {
            return -1;
        }
        if (this.msb > that.msb) {
            return 1;
        }
        if (this.lsb < that.lsb) {
            return -1;
        }
        if (this.lsb > that.lsb) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return new UUID(this.msb, this.lsb).toString();
    }

    public boolean equals(Object that) {
        return that instanceof NodeId && this.msb == ((NodeId)that).msb && this.lsb == ((NodeId)that).lsb;
    }

    public int hashCode() {
        return (int)(this.msb >>> 32 ^ this.msb ^ this.lsb >>> 32 ^ this.lsb);
    }
}

