/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.jackrabbit.core.query.lucene.OffsetCharSequence;
import org.apache.jackrabbit.core.query.lucene.RangeScan;
import org.apache.jackrabbit.core.query.lucene.TransformConstants;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FilteredTermEnum;

class WildcardTermEnum
extends FilteredTermEnum
implements TransformConstants {
    private final Matcher pattern;
    private final String field;
    private final TermValueFactory tvf;
    private final String prefix;
    private boolean endEnum = false;
    private final OffsetCharSequence input;
    private final int transform;

    public WildcardTermEnum(IndexReader reader, String field, TermValueFactory tvf, String pattern, int transform) throws IOException {
        int idx;
        if (transform < 0 || transform > 2) {
            throw new IllegalArgumentException("invalid transform parameter");
        }
        this.field = field;
        this.transform = transform;
        this.tvf = tvf;
        if (transform == 0) {
            for (idx = 0; idx < pattern.length() && (Character.isLetterOrDigit(pattern.charAt(idx)) || pattern.charAt(idx) == ':'); ++idx) {
            }
            this.prefix = tvf.createValue(pattern.substring(0, idx));
        } else {
            this.prefix = tvf.createValue("");
        }
        this.input = new OffsetCharSequence(this.prefix.length(), this.prefix, transform);
        this.pattern = Util.createRegexp(pattern.substring(idx)).matcher(this.input);
        if (transform == 0) {
            this.setEnum(reader.terms(new Term(field, this.prefix)));
        } else {
            this.setEnum(new LowerUpperCaseTermEnum(reader, field, pattern, transform));
        }
    }

    protected boolean termCompare(Term term) {
        if (this.transform == 0) {
            if (term.field() == this.field && term.text().startsWith(this.prefix)) {
                this.input.setBase(term.text());
                return this.pattern.reset().matches();
            }
            this.endEnum = true;
            return false;
        }
        return true;
    }

    public float difference() {
        return 1.0f;
    }

    protected boolean endEnum() {
        return this.endEnum;
    }

    public static class TermValueFactory {
        public String createValue(String s) {
            return s;
        }
    }

    private class LowerUpperCaseTermEnum
    extends TermEnum {
        private final Map<Term, Integer> orderedTerms = new LinkedHashMap<Term, Integer>();
        private final Iterator<Term> it;
        private Term current;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LowerUpperCaseTermEnum(IndexReader reader, String field, String pattern, int transform) throws IOException {
            if (transform != 1 && transform != 2) {
                throw new IllegalArgumentException("transform");
            }
            boolean neverMatches = false;
            for (int i = 0; i < pattern.length() && !neverMatches; ++i) {
                if (transform == 1) {
                    neverMatches = Character.isUpperCase(pattern.charAt(i));
                    continue;
                }
                if (transform != 2) continue;
                neverMatches = Character.isLowerCase(pattern.charAt(i));
            }
            if (!neverMatches) {
                ArrayList<RangeScan> rangeScans = new ArrayList<RangeScan>(2);
                try {
                    int idx;
                    for (idx = 0; idx < pattern.length() && Character.isLetterOrDigit(pattern.charAt(idx)); ++idx) {
                    }
                    String patternPrefix = pattern.substring(0, idx);
                    if (patternPrefix.length() == 0) {
                        String prefix = WildcardTermEnum.this.tvf.createValue("");
                        String limit = WildcardTermEnum.this.tvf.createValue("\uffff");
                        rangeScans.add(new RangeScan(reader, new Term(field, prefix), new Term(field, limit)));
                    } else {
                        StringBuffer lowerLimit = new StringBuffer(patternPrefix.toUpperCase());
                        lowerLimit.setCharAt(0, Character.toLowerCase(lowerLimit.charAt(0)));
                        String prefix = WildcardTermEnum.this.tvf.createValue(lowerLimit.toString());
                        StringBuffer upperLimit = new StringBuffer(patternPrefix.toLowerCase());
                        upperLimit.append('\uffff');
                        String limit = WildcardTermEnum.this.tvf.createValue(upperLimit.toString());
                        rangeScans.add(new RangeScan(reader, new Term(field, prefix), new Term(field, limit)));
                        prefix = WildcardTermEnum.this.tvf.createValue(patternPrefix.toUpperCase());
                        upperLimit = new StringBuffer(patternPrefix.toLowerCase());
                        upperLimit.setCharAt(0, Character.toUpperCase(upperLimit.charAt(0)));
                        upperLimit.append('\uffff');
                        limit = WildcardTermEnum.this.tvf.createValue(upperLimit.toString());
                        rangeScans.add(new RangeScan(reader, new Term(field, prefix), new Term(field, limit)));
                    }
                    for (RangeScan scan : rangeScans) {
                        do {
                            Term t;
                            if ((t = scan.term()) == null) continue;
                            WildcardTermEnum.this.input.setBase(t.text());
                            if (!WildcardTermEnum.this.pattern.reset().matches()) continue;
                            this.orderedTerms.put(t, scan.docFreq());
                        } while (scan.next());
                    }
                }
                finally {
                    for (RangeScan scan : rangeScans) {
                        try {
                            scan.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            this.it = this.orderedTerms.keySet().iterator();
            this.getNext();
        }

        public boolean next() {
            this.getNext();
            return this.current != null;
        }

        public Term term() {
            return this.current;
        }

        public int docFreq() {
            Integer docFreq = this.orderedTerms.get(this.current);
            return docFreq != null ? docFreq : 0;
        }

        public void close() {
        }

        private void getNext() {
            this.current = this.it.hasNext() ? this.it.next() : null;
        }
    }
}

