/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.UnmodifiableAccessControlList;
import org.apache.jackrabbit.core.security.authorization.acl.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.CompiledPermissionsImpl;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLProvider
extends AbstractAccessControlProvider
implements AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(ACLProvider.class);
    private NodeId rootNodeId;
    private EntryCollector entryCollector;

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        boolean initializedWithDefaults;
        super.init(systemSession, configuration);
        NodeImpl root = (NodeImpl)this.session.getRootNode();
        this.rootNodeId = root.getNodeId();
        ACLEditor systemEditor = new ACLEditor((Session)this.session, this);
        boolean bl = initializedWithDefaults = !configuration.containsKey("omit-default-permission");
        if (initializedWithDefaults && !ACLProvider.isAccessControlled(root)) {
            ACLProvider.initRootACL(this.session, systemEditor);
        }
        this.entryCollector = this.createEntryCollector(this.session);
    }

    @Override
    public void close() {
        super.close();
        this.entryCollector.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AccessControlPolicy[] getEffectivePolicies(Path absPath, CompiledPermissions permissions) throws ItemNotFoundException, RepositoryException {
        NodeImpl targetNode;
        this.checkInitialized();
        ArrayList<AccessControlList> acls = new ArrayList<AccessControlList>();
        if (absPath == null) {
            targetNode = (NodeImpl)this.session.getRootNode();
            if (ACLProvider.isRepoAccessControlled(targetNode)) {
                if (!permissions.grants(targetNode.getPrimaryPath(), 32)) throw new AccessDeniedException("Access denied at " + targetNode.getPath());
                acls.add(this.getACL(targetNode, N_REPO_POLICY, null));
            }
        } else {
            targetNode = (NodeImpl)this.session.getNode(this.session.getJCRPath(absPath));
            NodeImpl node = ACLProvider.getNode(targetNode, this.isAcItem(targetNode));
            this.collectAcls(node, permissions, acls);
        }
        if (!acls.isEmpty()) return (AccessControlPolicy[])acls.toArray(new AccessControlList[acls.size()]);
        log.warn("No access controlled node present in item hierarchy starting from " + targetNode.getPath());
        return (AccessControlPolicy[])acls.toArray(new AccessControlList[acls.size()]);
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals, CompiledPermissions permissions) throws RepositoryException {
        QueryResult result;
        String propName = ISO9075.encode((String)this.session.getJCRName(P_PRINCIPAL_NAME));
        StringBuilder stmt = new StringBuilder("/jcr:root");
        stmt.append("//element(*,");
        stmt.append(this.session.getJCRName(NT_REP_ACE));
        stmt.append(")[");
        int i = 0;
        for (Principal principal : principals) {
            if (i > 0) {
                stmt.append(" or ");
            }
            stmt.append("@");
            stmt.append(propName);
            stmt.append("='");
            stmt.append(principal.getName().replaceAll("'", "''"));
            stmt.append("'");
            ++i;
        }
        stmt.append("]");
        try {
            QueryManager qm = this.session.getWorkspace().getQueryManager();
            Query q = qm.createQuery(stmt.toString(), "xpath");
            result = q.execute();
        }
        catch (RepositoryException e) {
            log.error("Unexpected error while searching effective policies.", (Object)e.getMessage());
            throw new UnsupportedOperationException("Retrieve effective policies for set of principals not supported.", e);
        }
        LinkedHashSet<AccessControlList> acls = new LinkedHashSet<AccessControlList>();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            NodeImpl aclNode = (NodeImpl)it.nextNode().getParent();
            Name aclName = aclNode.getQName();
            NodeImpl accessControlledNode = (NodeImpl)aclNode.getParent();
            if (N_POLICY.equals(aclName) && ACLProvider.isAccessControlled(accessControlledNode)) {
                if (permissions.canRead(aclNode.getPrimaryPath(), aclNode.getNodeId())) {
                    acls.add(this.getACL(accessControlledNode, N_POLICY, accessControlledNode.getPath()));
                    continue;
                }
                throw new AccessDeniedException("Access denied at " + Text.getRelativeParent((String)aclNode.getPath(), (int)1));
            }
            if (!N_REPO_POLICY.equals(aclName) || !ACLProvider.isRepoAccessControlled(accessControlledNode)) continue;
            if (permissions.canRead(aclNode.getPrimaryPath(), aclNode.getNodeId())) {
                acls.add(this.getACL(accessControlledNode, N_REPO_POLICY, null));
                continue;
            }
            throw new AccessDeniedException("Access denied at " + Text.getRelativeParent((String)aclNode.getPath(), (int)1));
        }
        return acls.toArray(new AccessControlPolicy[acls.size()]);
    }

    @Override
    public AccessControlEditor getEditor(Session session) {
        this.checkInitialized();
        return new ACLEditor(session, this);
    }

    @Override
    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        if (this.isReadOnly(principals)) {
            return this.getReadOnlyPermissions();
        }
        return new CompiledPermissionsImpl(principals, this.session, this.entryCollector, this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAccessRoot(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        CompiledPermissionsImpl cp = new CompiledPermissionsImpl(principals, this.session, this.entryCollector, this, false);
        try {
            boolean bl = cp.canRead(null, this.rootNodeId);
            return bl;
        }
        finally {
            cp.close();
        }
    }

    protected EntryCollector createEntryCollector(SessionImpl systemSession) throws RepositoryException {
        return new CachingEntryCollector(systemSession, this.rootNodeId);
    }

    private void collectAcls(NodeImpl node, CompiledPermissions permissions, List<AccessControlList> acls) throws RepositoryException {
        if (ACLProvider.isAccessControlled(node)) {
            if (permissions.grants(node.getPrimaryPath(), 32)) {
                acls.add(this.getACL(node, N_POLICY, node.getPath()));
            } else {
                throw new AccessDeniedException("Access denied at " + node.getPath());
            }
        }
        if (!this.rootNodeId.equals(node.getId())) {
            NodeImpl parentNode = (NodeImpl)node.getParent();
            this.collectAcls(parentNode, permissions, acls);
        }
    }

    private AccessControlList getACL(NodeImpl accessControlledNode, Name policyName, String path) throws RepositoryException {
        NodeImpl aclNode = accessControlledNode.getNode(policyName);
        ACLTemplate acl = new ACLTemplate(aclNode, path);
        return new UnmodifiableAccessControlList((AccessControlList)acl);
    }

    private static void initRootACL(SessionImpl session, AccessControlEditor editor) throws RepositoryException {
        try {
            log.debug("Install initial ACL:...");
            String rootPath = session.getRootNode().getPath();
            AccessControlPolicy[] acls = editor.editAccessControlPolicies(rootPath);
            if (acls.length > 0) {
                Privilege[] privs;
                ACLTemplate acl = (ACLTemplate)acls[0];
                PrincipalManager pMgr = session.getPrincipalManager();
                AccessControlManager acMgr = session.getAccessControlManager();
                String pName = "administrators";
                if (pMgr.hasPrincipal(pName)) {
                    Principal administrators = pMgr.getPrincipal(pName);
                    log.debug("... Privilege.ALL for administrators.");
                    privs = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")};
                    acl.addAccessControlEntry(administrators, privs);
                } else {
                    log.info("Administrators principal group is missing -> omitting initialization of default permissions.");
                }
                Principal everyone = pMgr.getEveryone();
                log.debug("... Privilege.READ for everyone.");
                privs = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")};
                acl.addAccessControlEntry(everyone, privs);
                editor.setPolicy(rootPath, (AccessControlPolicy)acl);
                session.save();
            } else {
                log.info("No applicable ACL available for the root node -> skip initialization of the root node's ACL.");
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to set-up minimal access control for root node of workspace " + session.getWorkspace().getName());
            session.getRootNode().refresh(false);
        }
    }

    static boolean isAccessControlled(NodeImpl node) throws RepositoryException {
        return node.isAccessControllable();
    }

    static boolean isRepoAccessControlled(NodeImpl node) throws RepositoryException {
        return node.hasNode(N_REPO_POLICY) && node.isNodeType(NT_REP_REPO_ACCESS_CONTROLLABLE);
    }

    static NodeImpl getNode(NodeImpl targetNode, boolean isAcItem) throws RepositoryException {
        Name ntName;
        NodeImpl node = isAcItem ? ((ntName = ((NodeTypeImpl)targetNode.getPrimaryNodeType()).getQName()).equals(NT_REP_ACL) ? (NodeImpl)targetNode.getParent() : (ntName.equals(NT_REP_GRANT_ACE) || ntName.equals(NT_REP_DENY_ACE) ? (NodeImpl)targetNode.getParent().getParent() : targetNode)) : targetNode;
        return node;
    }
}

