/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.ci.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A permission scheme that is applied to any number of configuration items.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A permission scheme to apply to a configuration item.", category = "permission schemes")
public class PermissionScheme extends BaseConfigurationItem {

	@ConfigurationItemProperty(required = true, description = "Access control entries.")
	private List<AccessControlEntry> accessControlEntries = new ArrayList<AccessControlEntry>();

	@ConfigurationItemProperty(required = false, description = "Allowed CI types.")
	private Set<String> allowedCiTypes = new HashSet<String>();

	public AccessControlEntry getApplicablePermissions(String username, Collection<String> groupNames) {
		AccessControlEntry mergedAclEntry = AccessControlEntry.getNoPermissions(username);
		for (AccessControlEntry each : getAccessControlEntries()) {
			if (groupNames.contains(each.getGroupName())) {
				mergedAclEntry.merge(each);
			}
		}
		return mergedAclEntry;
	}

	public List<AccessControlEntry> getAccessControlEntries() {
		return accessControlEntries;
	}

	public void setAccessControlEntries(List<AccessControlEntry> accessControlEntries) {
		if (accessControlEntries == null) {
			this.accessControlEntries = new ArrayList<AccessControlEntry>();
		} else {
			this.accessControlEntries = accessControlEntries;
		}
	}

	public Set<String> getAllowedCiTypes() {
		return allowedCiTypes;
	}

	public void setAllowedCiTypes(Set<String> allowedCiTypes) {
		this.allowedCiTypes = allowedCiTypes;
	}

}
