/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.hostsession.common;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

import org.apache.log4j.Logger;

import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;

/**
 * Checks the output of an executed command and gives canned responses to expected output.
 */
public class InputResponseHandler implements CommandExecutionCallbackHandler {

	private OutputStream os;
	private Map<String, String> inputResponse;
	private CommandExecutionCallbackHandler handler;
	private StringBuffer output = new StringBuffer();

	public InputResponseHandler(CommandExecutionCallbackHandler handler, OutputStream os, Map<String, String> inputResponse) {
		this.os = os;
		this.inputResponse = inputResponse;
		this.handler = handler;
	}

	public void handleErrorLine(String line) {
		handler.handleErrorLine(line);
	}

	public void handleOutput(char c) {
		output.append(c);
		String totalOutput = output.toString();

		for (String key : inputResponse.keySet()) {
			if (totalOutput.endsWith(key)) {
				String response = inputResponse.get(key);
				try {
					if (logger.isDebugEnabled()) {
						logger.debug("Sending response " + response);
					}
					os.write(response.getBytes());
					os.flush();
				} catch (IOException e) {
					logger.error(e.getMessage());
				}
			}
		}
	}

	public void handleOutputLine(String line) {
		handler.handleOutputLine(line);
	}

	private static Logger logger = Logger.getLogger(InputResponseHandler.class.getName());

}
