/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession;

import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CapturingCommandExecutionCallbackHandler
implements CommandExecutionCallbackHandler {
    private List<String> outputLines = new ArrayList<String>();
    private List<String> errorLines = new ArrayList<String>();
    private List<String> allLines = new ArrayList<String>();

    @Override
    public void handleOutputLine(String line) {
        this.outputLines.add(line);
        this.allLines.add(line);
    }

    @Override
    public void handleErrorLine(String line) {
        this.errorLines.add(line);
        this.allLines.add(line);
    }

    @Override
    public void handleOutput(char c) {
    }

    public List<String> getOutputLines() {
        return Collections.unmodifiableList(this.outputLines);
    }

    public String getOutput() {
        return StringUtils.join(this.outputLines, (String)"\n");
    }

    public List<String> getErrorLines() {
        return Collections.unmodifiableList(this.errorLines);
    }

    public String getError() {
        return StringUtils.join(this.errorLines, (String)"\n");
    }

    public List<String> getAllLines() {
        return Collections.unmodifiableList(this.allLines);
    }

    public String getAll() {
        return StringUtils.join(this.allLines, (String)"\n");
    }

    public String toString() {
        return this.getClass().getName() + "[output=\"" + this.getOutput() + "\", error=\"" + this.getError() + "\"]";
    }
}

